/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class HardcodedStringExpressionChecker {
    private static final String SECONDARY_LOCATION_ISSUE_MESSAGE = "The static value is defined here.";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final MethodMatchers STRING_CONSTRUCTOR = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).constructor().addParametersMatcher(parameters -> !parameters.isEmpty()).build();
    private static final MethodMatchers STRING_TO_ARRAY_METHODS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"getBytes", "toLowerCase", "toUpperCase"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"toCharArray", "trim", "strip", "stripIndent", "stripLeading", "stripTrailing", "intern", "translateEscapes"}).addWithoutParametersMatcher().build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"subSequence", "substring"}).addParametersMatcher(new String[]{"int"}).addParametersMatcher(new String[]{"int", "int"}).build(), MethodMatchers.create().ofAnyType().names(new String[]{"toString"}).addWithoutParametersMatcher().build()});
    private static final MethodMatchers STRING_VALUE_OF = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"valueOf"}).withAnyParameters().build();

    private HardcodedStringExpressionChecker() {
    }

    public static boolean isExpressionDerivedFromPlainText(ExpressionTree expression, List<JavaFileScannerContext.Location> secondaryLocations, Set<Symbol> visited) {
        ExpressionTree arg = ExpressionUtils.skipParentheses((ExpressionTree)expression);
        switch (arg.kind()) {
            case IDENTIFIER: {
                IdentifierTree identifier = (IdentifierTree)arg;
                return HardcodedStringExpressionChecker.isDerivedFromPlainText(identifier, secondaryLocations, visited);
            }
            case NEW_ARRAY: {
                NewArrayTree newArrayTree = (NewArrayTree)arg;
                return HardcodedStringExpressionChecker.isDerivedFromPlainText(newArrayTree, secondaryLocations, visited);
            }
            case NEW_CLASS: {
                NewClassTree newClassTree = (NewClassTree)arg;
                return HardcodedStringExpressionChecker.isDerivedFromPlainText(newClassTree, secondaryLocations, visited);
            }
            case METHOD_INVOCATION: {
                MethodInvocationTree methodInvocationTree = (MethodInvocationTree)arg;
                return HardcodedStringExpressionChecker.isDerivedFromPlainText(methodInvocationTree, secondaryLocations, visited);
            }
            case CONDITIONAL_EXPRESSION: {
                ConditionalExpressionTree conditionalTree = (ConditionalExpressionTree)arg;
                return HardcodedStringExpressionChecker.isDerivedFromPlainText(conditionalTree, secondaryLocations, visited);
            }
            case MEMBER_SELECT: {
                MemberSelectExpressionTree memberSelect = (MemberSelectExpressionTree)arg;
                return HardcodedStringExpressionChecker.isDerivedFromPlainText(memberSelect.identifier(), secondaryLocations, visited);
            }
            case STRING_LITERAL: {
                return !LiteralUtils.isEmptyString((Tree)arg);
            }
            case TYPE_CAST: {
                TypeCastTree typeCast = (TypeCastTree)arg;
                return HardcodedStringExpressionChecker.isExpressionDerivedFromPlainText(typeCast.expression(), secondaryLocations, visited);
            }
            case BOOLEAN_LITERAL: 
            case CHAR_LITERAL: 
            case DOUBLE_LITERAL: 
            case FLOAT_LITERAL: 
            case INT_LITERAL: 
            case LONG_LITERAL: {
                return true;
            }
        }
        if (arg instanceof BinaryExpressionTree) {
            BinaryExpressionTree binaryExpression = (BinaryExpressionTree)arg;
            return HardcodedStringExpressionChecker.isDerivedFromPlainText(binaryExpression, secondaryLocations, visited);
        }
        return false;
    }

    private static boolean isDerivedFromPlainText(BinaryExpressionTree binaryExpression, List<JavaFileScannerContext.Location> secondaryLocations, Set<Symbol> visited) {
        return HardcodedStringExpressionChecker.isExpressionDerivedFromPlainText(binaryExpression.rightOperand(), secondaryLocations, visited) && HardcodedStringExpressionChecker.isExpressionDerivedFromPlainText(binaryExpression.leftOperand(), secondaryLocations, visited);
    }

    private static boolean isDerivedFromPlainText(IdentifierTree identifier, List<JavaFileScannerContext.Location> secondaryLocations, Set<Symbol> visited) {
        boolean identifierIsDerivedFromPlainText;
        Symbol symbol = identifier.symbol();
        boolean firstVisit = visited.add(symbol);
        if (!firstVisit || !symbol.isVariableSymbol() || JUtils.isParameter((Symbol)symbol) || HardcodedStringExpressionChecker.isNonFinalField(symbol)) {
            return false;
        }
        VariableTree variable = (VariableTree)symbol.declaration();
        if (variable == null) {
            return JUtils.constantValue((Symbol.VariableSymbol)((Symbol.VariableSymbol)symbol)).isPresent();
        }
        List<ExpressionTree> assignments = ExpressionsHelper.getIdentifierAssignments(identifier);
        ArrayList tempSecondaryLocations = new ArrayList();
        boolean bl = identifierIsDerivedFromPlainText = !assignments.isEmpty() && assignments.stream().allMatch(expression -> HardcodedStringExpressionChecker.isExpressionDerivedFromPlainText(expression, tempSecondaryLocations, visited));
        if (identifierIsDerivedFromPlainText) {
            if (variable.initializer() == null) {
                secondaryLocations.add(new JavaFileScannerContext.Location(SECONDARY_LOCATION_ISSUE_MESSAGE, (Tree)variable));
            } else {
                secondaryLocations.add(new JavaFileScannerContext.Location(SECONDARY_LOCATION_ISSUE_MESSAGE, (Tree)variable.initializer()));
            }
            secondaryLocations.addAll(tempSecondaryLocations);
            return true;
        }
        return false;
    }

    private static boolean isNonFinalField(Symbol symbol) {
        return symbol.isVariableSymbol() && symbol.owner().isTypeSymbol() && !symbol.isFinal();
    }

    private static boolean isDerivedFromPlainText(NewArrayTree invocation, List<JavaFileScannerContext.Location> secondaryLocations, Set<Symbol> visited) {
        ListTree initializers = invocation.initializers();
        return !initializers.isEmpty() && initializers.stream().allMatch(expression -> HardcodedStringExpressionChecker.isExpressionDerivedFromPlainText(expression, secondaryLocations, visited));
    }

    private static boolean isDerivedFromPlainText(NewClassTree invocation, List<JavaFileScannerContext.Location> secondaryLocations, Set<Symbol> visited) {
        return STRING_CONSTRUCTOR.matches(invocation) && HardcodedStringExpressionChecker.isExpressionDerivedFromPlainText((ExpressionTree)invocation.arguments().get(0), secondaryLocations, visited);
    }

    private static boolean isDerivedFromPlainText(MethodInvocationTree invocation, List<JavaFileScannerContext.Location> secondaryLocations, Set<Symbol> visited) {
        if (STRING_VALUE_OF.matches(invocation)) {
            return HardcodedStringExpressionChecker.isExpressionDerivedFromPlainText((ExpressionTree)invocation.arguments().get(0), secondaryLocations, visited);
        }
        if (!STRING_TO_ARRAY_METHODS.matches(invocation)) {
            return false;
        }
        ExpressionTree methodSelect = ExpressionUtils.skipParentheses((ExpressionTree)invocation.methodSelect());
        return methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && HardcodedStringExpressionChecker.isExpressionDerivedFromPlainText(((MemberSelectExpressionTree)methodSelect).expression(), secondaryLocations, visited);
    }

    private static boolean isDerivedFromPlainText(ConditionalExpressionTree conditionalTree, List<JavaFileScannerContext.Location> secondaryLocations, Set<Symbol> visited) {
        return HardcodedStringExpressionChecker.isExpressionDerivedFromPlainText(conditionalTree.trueExpression(), secondaryLocations, visited) && HardcodedStringExpressionChecker.isExpressionDerivedFromPlainText(conditionalTree.falseExpression(), secondaryLocations, visited);
    }
}

