/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.java.annotations.Beta;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.model.DefaultJavaFileScannerContext;
import org.sonar.java.model.JavaTree;
import org.sonar.java.reporting.InternalJavaIssueBuilder;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.location.Position;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.PackageDeclarationTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.collections.ListUtils;

@Beta
public class QuickFixHelper {
    private QuickFixHelper() {
    }

    public static InternalJavaIssueBuilder newIssue(JavaFileScannerContext context) {
        return (InternalJavaIssueBuilder)QuickFixHelper.internalContext(context).newIssue();
    }

    public static DefaultJavaFileScannerContext internalContext(JavaFileScannerContext context) {
        return (DefaultJavaFileScannerContext)context;
    }

    public static SyntaxToken nextToken(Tree tree) {
        Tree parent = tree.parent();
        if (parent == null) {
            return tree.lastToken();
        }
        List children = ((JavaTree)parent).getChildren();
        if (tree.equals(ListUtils.getLast((List)children))) {
            return QuickFixHelper.nextToken(parent);
        }
        SyntaxToken nextToken = tree.lastToken();
        for (int i = children.indexOf(tree) + 1; i < children.size(); ++i) {
            SyntaxToken token = ((Tree)children.get(i)).firstToken();
            if (token == null) continue;
            nextToken = token;
            break;
        }
        return nextToken;
    }

    public static SyntaxToken previousToken(Tree tree) {
        Tree parent = tree.parent();
        if (parent == null) {
            return tree.firstToken();
        }
        List children = ((JavaTree)parent).getChildren();
        if (tree.equals(children.get(0))) {
            return QuickFixHelper.previousToken(parent);
        }
        for (int i = children.indexOf(tree) - 1; i >= 0; --i) {
            SyntaxToken token = ((Tree)children.get(i)).lastToken();
            if (token == null) continue;
            return token;
        }
        return QuickFixHelper.previousToken(parent);
    }

    public static Optional<VariableTree> previousVariable(VariableTree current) {
        return QuickFixHelper.previousVariable(current, QuickFixHelper.getSiblings(current));
    }

    private static Optional<VariableTree> previousVariable(VariableTree current, List<? extends Tree> trees) {
        int currentIndex = trees.indexOf(current);
        if (currentIndex <= 0) {
            return Optional.empty();
        }
        Tree preceding = trees.get(currentIndex - 1);
        if (preceding.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && preceding.firstToken().equals((Object)current.firstToken())) {
            return Optional.of((VariableTree)preceding);
        }
        return Optional.empty();
    }

    public static Optional<VariableTree> nextVariable(VariableTree variable) {
        return QuickFixHelper.nextVariable(variable, QuickFixHelper.getSiblings(variable));
    }

    private static Optional<VariableTree> nextVariable(VariableTree current, List<? extends Tree> trees) {
        int currentIndex = trees.indexOf(current);
        if (currentIndex == -1 || trees.size() <= currentIndex + 1) {
            return Optional.empty();
        }
        Tree following = trees.get(currentIndex + 1);
        if (following.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && following.firstToken().equals((Object)current.firstToken())) {
            return Optional.of((VariableTree)following);
        }
        return Optional.empty();
    }

    private static List<? extends Tree> getSiblings(VariableTree current) {
        Tree parent = current.parent();
        switch (parent.kind()) {
            case LIST: {
                return (List)parent;
            }
            case BLOCK: 
            case INITIALIZER: 
            case STATIC_INITIALIZER: {
                return ((JavaTree)parent).getChildren();
            }
            case CASE_GROUP: {
                return ((CaseGroupTree)parent).body();
            }
            case METHOD: 
            case CONSTRUCTOR: 
            case CATCH: 
            case LAMBDA_EXPRESSION: 
            case FOR_EACH_STATEMENT: 
            case PATTERN_INSTANCE_OF: {
                return Collections.emptyList();
            }
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case ANNOTATION_TYPE: {
                return ((ClassTree)parent).members();
            }
            case RECORD: {
                ClassTree classLike = (ClassTree)parent;
                return classLike.recordComponents().contains(current) ? Collections.emptyList() : classLike.members();
            }
        }
        throw new IllegalArgumentException("The variable's parent kind " + String.valueOf(parent.kind()) + " is not handled by this method!");
    }

    public static String contentForTree(Tree tree, JavaFileScannerContext context) {
        SyntaxToken firstToken = tree.firstToken();
        if (firstToken == null) {
            return "";
        }
        return QuickFixHelper.contentForRange(firstToken, tree.lastToken(), context);
    }

    public static String contentForRange(SyntaxToken firstToken, SyntaxToken lastToken, JavaFileScannerContext context) {
        Position firstPosition = Position.startOf((SyntaxToken)firstToken);
        Position lastPosition = Position.endOf((SyntaxToken)lastToken);
        int startLine = firstPosition.line();
        int endLine = lastPosition.line();
        int beginIndex = firstPosition.columnOffset();
        int endIndex = lastPosition.columnOffset();
        if (startLine == endLine) {
            return ((String)context.getFileLines().get(startLine - 1)).substring(beginIndex, endIndex);
        }
        List lines = context.getFileLines().subList(startLine - 1, endLine);
        StringBuilder sb = new StringBuilder();
        sb.append(((String)lines.get(0)).substring(beginIndex)).append("\n");
        for (int i = 1; i < lines.size() - 1; ++i) {
            sb.append((String)lines.get(i)).append("\n");
        }
        sb.append((CharSequence)ListUtils.getLast(lines), 0, endIndex);
        return sb.toString();
    }

    public static ImportSupplier newImportSupplier(JavaFileScannerContext context) {
        return new ImportSupplier(context.getTree());
    }

    public static class ImportSupplier {
        @Nullable
        private final PackageDeclarationTree packageDeclaration;
        @Nullable
        private final String packageName;
        @Nullable
        private final Tree firstType;
        private final List<ImportWithName> sortedNonStaticImports;
        private final Set<String> importedTypes;
        private final Set<String> starImportPackages;
        private final Map<String, Optional<JavaTextEdit>> cachedResults = new HashMap<String, Optional<JavaTextEdit>>();

        private ImportSupplier(CompilationUnitTree cut) {
            this.packageDeclaration = cut.packageDeclaration();
            this.packageName = this.packageDeclaration == null ? null : ExpressionsHelper.concatenate(this.packageDeclaration.packageName());
            List types = cut.types();
            this.firstType = types.isEmpty() ? null : (Tree)types.get(0);
            this.sortedNonStaticImports = new ArrayList<ImportWithName>();
            this.importedTypes = new HashSet<String>();
            this.starImportPackages = new HashSet<String>();
            cut.imports().stream().filter(importClauseTree -> importClauseTree.is(new Tree.Kind[]{Tree.Kind.IMPORT})).map(ImportTree.class::cast).filter(importTree -> !importTree.isStatic()).map(x$0 -> new ImportWithName((ImportTree)x$0)).sorted(ImportWithName.COMPARATOR).forEach(importWithName -> {
                this.sortedNonStaticImports.add((ImportWithName)importWithName);
                String importName = importWithName.importName();
                if (importName.endsWith(".*")) {
                    this.starImportPackages.add(ImportSupplier.typeToPackageName(importName));
                } else {
                    this.importedTypes.add(importName);
                }
            });
        }

        public Optional<JavaTextEdit> newImportEdit(String requiredType) {
            return this.cachedResults.computeIfAbsent(requiredType, this::locateNewImportEdit);
        }

        private Optional<JavaTextEdit> locateNewImportEdit(String requiredType) {
            ImportWithName importWithName;
            String importedType;
            if (!this.requiresImportOf(requiredType)) {
                return Optional.empty();
            }
            if (this.sortedNonStaticImports.isEmpty()) {
                if (this.packageDeclaration != null) {
                    return Optional.of(JavaTextEdit.insertAfterTree((Tree)this.packageDeclaration, (String)String.format("\n\nimport %s;", requiredType)));
                }
                if (this.firstType != null) {
                    return Optional.of(JavaTextEdit.insertBeforeTree((Tree)this.firstType, (String)String.format("import %s;\n\n", requiredType)));
                }
                return Optional.empty();
            }
            ImportTree lastCheckedImport = null;
            Iterator<ImportWithName> iterator = this.sortedNonStaticImports.iterator();
            while (iterator.hasNext() && requiredType.compareTo(importedType = (importWithName = iterator.next()).importName()) > 0) {
                lastCheckedImport = importWithName.tree();
            }
            if (lastCheckedImport != null) {
                return Optional.of(JavaTextEdit.insertAfterTree(lastCheckedImport, (String)String.format("\nimport %s;", requiredType)));
            }
            return Optional.of(JavaTextEdit.insertBeforeTree((Tree)this.sortedNonStaticImports.get(0).tree(), (String)String.format("import %s;\n", requiredType)));
        }

        @VisibleForTesting
        boolean requiresImportOf(String requiredType) {
            if (!requiredType.contains(".") || this.importedTypes.contains(requiredType)) {
                return false;
            }
            String requiredPackage = ImportSupplier.typeToPackageName(requiredType);
            if (this.starImportPackages.contains(requiredPackage)) {
                return false;
            }
            return !requiredPackage.equals(this.packageName);
        }

        private static String typeToPackageName(String requiredType) {
            return requiredType.substring(0, requiredType.lastIndexOf("."));
        }

        private static class ImportWithName {
            private static final Comparator<ImportWithName> COMPARATOR = (i1, i2) -> i1.importName.compareTo(i2.importName);
            private final String importName;
            private final ImportTree tree;

            private ImportWithName(ImportTree tree) {
                this.tree = tree;
                this.importName = ExpressionsHelper.concatenate((ExpressionTree)tree.qualifiedIdentifier());
            }

            public ImportTree tree() {
                return this.tree;
            }

            public String importName() {
                return this.importName;
            }
        }
    }
}

