/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.WildcardTree;

@Rule(key="S4968")
public class TypeUpperBoundNotFinalCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.TYPE_PARAMETER, Tree.Kind.EXTENDS_WILDCARD);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.TYPE_PARAMETER})) {
            this.handleBounds((List<TypeTree>)((TypeParameterTree)tree).bounds(), tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.EXTENDS_WILDCARD})) {
            this.handleBounds(Collections.singletonList(((WildcardTree)tree).bound()), tree);
        }
    }

    private void handleBounds(List<TypeTree> bounds, Tree treeToReport) {
        bounds.stream().map(TypeUpperBoundNotFinalCheck::getIdentifier).flatMap(Optional::stream).filter(bound -> TypeUpperBoundNotFinalCheck.isFinal(bound) && !TypeUpperBoundNotFinalCheck.inOverridingMethodDeclaration(treeToReport)).findFirst().ifPresent(identifierTree -> this.reportIssue(treeToReport, "Replace this type parametrization by the 'final' type `" + identifierTree.name() + "`."));
    }

    private static Optional<IdentifierTree> getIdentifier(TypeTree t) {
        if (t.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return Optional.of((IdentifierTree)t);
        }
        if (t.is(new Tree.Kind[]{Tree.Kind.PARAMETERIZED_TYPE})) {
            ParameterizedTypeTree type = (ParameterizedTypeTree)t;
            return TypeUpperBoundNotFinalCheck.getIdentifier(type.type());
        }
        return Optional.empty();
    }

    private static boolean isFinal(IdentifierTree bound) {
        return bound.symbol().isFinal();
    }

    private static boolean inOverridingMethodDeclaration(Tree type) {
        return TypeUpperBoundNotFinalCheck.getMethodDeclaration(type).filter(TypeUpperBoundNotFinalCheck::isOverriding).isPresent();
    }

    private static Optional<MethodTree> getMethodDeclaration(Tree type) {
        for (Tree parent = type.parent(); parent != null && !parent.is(new Tree.Kind[]{Tree.Kind.BLOCK}); parent = parent.parent()) {
            if (!parent.is(new Tree.Kind[]{Tree.Kind.METHOD})) continue;
            return Optional.of((MethodTree)parent);
        }
        return Optional.empty();
    }

    private static boolean isOverriding(MethodTree method) {
        return !Boolean.FALSE.equals(method.isOverriding());
    }
}

