/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractCallToDeprecatedCodeChecker;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="CallToDeprecatedMethod", repositoryKey="squid")
@Rule(key="S1874")
public class CallToDeprecatedMethodCheck
extends AbstractCallToDeprecatedCodeChecker {
    @Override
    void checkDeprecatedIdentifier(IdentifierTree identifierTree, Symbol deprecatedSymbol) {
        if (this.isFlaggedForRemoval(deprecatedSymbol)) {
            return;
        }
        String name = deprecatedSymbol.name();
        if (CallToDeprecatedMethodCheck.isConstructor(deprecatedSymbol)) {
            name = deprecatedSymbol.owner().name();
        }
        this.reportIssue((Tree)identifierTree, String.format("Remove this use of \"%s\"; it is deprecated.", name));
    }

    @Override
    void checkOverridingMethod(MethodTree methodTree, List<Symbol.MethodSymbol> deprecatedSymbols) {
        if (deprecatedSymbols.stream().allMatch(this::nonAbstractOrFlaggedForRemoval)) {
            this.reportIssue((Tree)methodTree.simpleName(), "Don't override a deprecated method or explicitly mark it as \"@Deprecated\".");
        }
    }

    private boolean nonAbstractOrFlaggedForRemoval(Symbol.MethodSymbol method) {
        return !method.isAbstract() && !this.isFlaggedForRemoval((Symbol)method);
    }
}

