/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S3064")
public class DoubleCheckedLockingAssignmentCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.IF_STATEMENT);
    }

    public void visitNode(Tree tree) {
        IfStatementTree ifStatementTree = (IfStatementTree)tree;
        StatementTree body = DoubleCheckedLockingAssignmentCheck.getOnlyStatement(ifStatementTree);
        if (body == null || !body.is(new Tree.Kind[]{Tree.Kind.SYNCHRONIZED_STATEMENT})) {
            return;
        }
        List synchronizedBody = ((SynchronizedStatementTree)body).block().body();
        if (synchronizedBody.isEmpty()) {
            return;
        }
        Symbol symbol = DoubleCheckedLockingAssignmentCheck.nullCheck(ifStatementTree.condition());
        if (symbol == null || !symbol.owner().isTypeSymbol()) {
            return;
        }
        for (StatementTree statementTree : synchronizedBody) {
            IfStatementTree secondIf;
            Symbol secondIfSymbol;
            if (!statementTree.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT}) || !symbol.equals(secondIfSymbol = DoubleCheckedLockingAssignmentCheck.nullCheck((secondIf = (IfStatementTree)statementTree).condition()))) continue;
            this.checkUsageAfterAssignment(symbol, secondIf.thenStatement());
        }
    }

    private void checkUsageAfterAssignment(Symbol symbol, StatementTree thenStatement) {
        if (thenStatement.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            List body = ((BlockTree)thenStatement).body();
            AssignmentExpressionTree foundAssignment = null;
            UsageVisitor usageVisitor = new UsageVisitor(symbol);
            for (StatementTree statementTree : body) {
                AssignmentExpressionTree assignment;
                if (foundAssignment != null) {
                    statementTree.accept((TreeVisitor)usageVisitor);
                }
                if ((assignment = DoubleCheckedLockingAssignmentCheck.isAssignmentToSymbol(statementTree, symbol)) == null) continue;
                foundAssignment = assignment;
            }
            if (foundAssignment != null && !usageVisitor.usages.isEmpty()) {
                this.reportIssue((Tree)foundAssignment, "Fully initialize \"" + symbol.name() + "\" before assigning it.", usageVisitor.locations(), null);
            }
        }
    }

    @CheckForNull
    private static AssignmentExpressionTree isAssignmentToSymbol(StatementTree statementTree, Symbol symbol) {
        AssignmentExpressionTree assignment;
        if (!statementTree.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT})) {
            return null;
        }
        ExpressionTree expr = ((ExpressionStatementTree)statementTree).expression();
        if (expr.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) && symbol.equals(DoubleCheckedLockingAssignmentCheck.symbol((assignment = (AssignmentExpressionTree)expr).variable()))) {
            return assignment;
        }
        return null;
    }

    @CheckForNull
    private static StatementTree getOnlyStatement(IfStatementTree ifStatementTree) {
        BlockTree blockTree;
        StatementTree thenStatement = ifStatementTree.thenStatement();
        if (thenStatement.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT})) {
            return thenStatement;
        }
        if (thenStatement.is(new Tree.Kind[]{Tree.Kind.BLOCK}) && (blockTree = (BlockTree)thenStatement).body().size() == 1) {
            return (StatementTree)blockTree.body().get(0);
        }
        return null;
    }

    @CheckForNull
    private static Symbol nullCheck(ExpressionTree tree) {
        if (!tree.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO})) {
            return null;
        }
        BinaryExpressionTree equalTo = (BinaryExpressionTree)tree;
        ExpressionTree lhs = equalTo.leftOperand();
        ExpressionTree rhs = equalTo.rightOperand();
        Symbol symbol = DoubleCheckedLockingAssignmentCheck.symbol(lhs);
        if (symbol != null && rhs.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) {
            return symbol;
        }
        symbol = DoubleCheckedLockingAssignmentCheck.symbol(rhs);
        if (symbol != null && lhs.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) {
            return symbol;
        }
        return null;
    }

    @CheckForNull
    private static Symbol symbol(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return ((IdentifierTree)tree).symbol();
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return ((MemberSelectExpressionTree)tree).identifier().symbol();
        }
        return null;
    }

    static class UsageVisitor
    extends BaseTreeVisitor {
        private final Symbol symbol;
        List<IdentifierTree> usages = new ArrayList<IdentifierTree>();

        public UsageVisitor(Symbol symbol) {
            this.symbol = symbol;
        }

        public void visitIdentifier(IdentifierTree tree) {
            if (this.symbol.equals(tree.symbol())) {
                this.usages.add(tree);
            }
        }

        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }

        public void visitNewClass(NewClassTree tree) {
        }

        public void visitMethod(MethodTree tree) {
        }

        List<JavaFileScannerContext.Location> locations() {
            return this.usages.stream().map(u -> new JavaFileScannerContext.Location("Usage after assignment", (Tree)u)).collect(Collectors.toList());
        }
    }
}

