/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.matcher.MethodMatchersBuilder;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.UnionTypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2142")
public class InterruptedExceptionCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "Either re-interrupt this method or rethrow the \"%s\" that can be caught here.";
    private static final Predicate<Type> INTERRUPTING_TYPE_PREDICATE = catchType -> catchType.is("java.lang.InterruptedException") || catchType.is("java.lang.ThreadDeath");
    private static final Predicate<Type> GENERIC_EXCEPTION_PREDICATE = catchType -> catchType.is("java.lang.Exception") || catchType.is("java.lang.Throwable");
    private Deque<Boolean> withinInterruptingFinally = new LinkedList<Boolean>();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.TRY_STATEMENT);
    }

    public void leaveFile(JavaFileScannerContext context) {
        this.withinInterruptingFinally.clear();
    }

    public void visitNode(Tree tree) {
        TryStatementTree tryStatementTree = (TryStatementTree)tree;
        this.withinInterruptingFinally.addFirst(InterruptedExceptionCheck.isFinallyInterrupting(tryStatementTree.finallyBlock()));
        for (CatchTree catchTree : tryStatementTree.catches()) {
            VariableTree catchParameter = catchTree.parameter();
            List<Type> caughtTypes = InterruptedExceptionCheck.getCaughtTypes(catchParameter);
            Optional<Type> interruptType = caughtTypes.stream().filter(INTERRUPTING_TYPE_PREDICATE).findFirst();
            if (interruptType.isPresent()) {
                if (this.wasNotInterrupted(catchTree)) {
                    this.reportIssue((Tree)catchParameter, String.format(MESSAGE, interruptType.get().name()));
                }
                return;
            }
            if (!caughtTypes.stream().anyMatch(GENERIC_EXCEPTION_PREDICATE)) continue;
            this.reportIfThrowInterruptInBlock(tryStatementTree.block(), catchTree);
            return;
        }
    }

    private void reportIfThrowInterruptInBlock(BlockTree blockTree, CatchTree catchTree) {
        MethodTreeUtils.MethodInvocationCollector collector = new MethodTreeUtils.MethodInvocationCollector(InterruptedExceptionCheck::throwInterruptedException);
        blockTree.accept((TreeVisitor)collector);
        List<Tree> invocationInterrupting = collector.getInvocationTree();
        if (!invocationInterrupting.isEmpty() && this.wasNotInterrupted(catchTree)) {
            this.reportIssue((Tree)catchTree.parameter(), String.format(MESSAGE, "InterruptedException"), invocationInterrupting.stream().map(t -> new JavaFileScannerContext.Location("Method invocation throwing InterruptedException.", t)).collect(Collectors.toList()), null);
        }
    }

    private boolean wasNotInterrupted(CatchTree catchTree) {
        BlockVisitor blockVisitor = new BlockVisitor(catchTree.parameter().symbol());
        catchTree.block().accept((TreeVisitor)blockVisitor);
        return !blockVisitor.threadInterrupted && !this.isWithinInterruptingFinally();
    }

    private static List<Type> getCaughtTypes(VariableTree parameter) {
        if (parameter.type().is(new Tree.Kind[]{Tree.Kind.UNION_TYPE})) {
            return ((UnionTypeTree)parameter.type()).typeAlternatives().stream().map(TypeTree::symbolType).collect(Collectors.toList());
        }
        return Collections.singletonList(parameter.symbol().type());
    }

    private boolean isWithinInterruptingFinally() {
        return this.withinInterruptingFinally.stream().anyMatch(Boolean.TRUE::equals);
    }

    public void leaveNode(Tree tree) {
        this.withinInterruptingFinally.removeFirst();
    }

    private static boolean isFinallyInterrupting(@Nullable BlockTree blockTree) {
        if (blockTree == null) {
            return false;
        }
        BlockVisitor blockVisitor = new BlockVisitor();
        blockTree.accept((TreeVisitor)blockVisitor);
        return blockVisitor.threadInterrupted;
    }

    private static boolean throwInterruptedException(Symbol symbol) {
        return symbol.isMethodSymbol() && ((Symbol.MethodSymbol)symbol).thrownTypes().stream().anyMatch(t -> t.is("java.lang.InterruptedException"));
    }

    private static class BlockVisitor
    extends BaseTreeVisitor {
        @Nullable
        private final Symbol catchedException;
        boolean threadInterrupted = false;
        private int depth = 0;
        private static final int MAX_DEPTH = 3;
        private static final MethodMatchers INTERRUPT_MATCHERS = new MethodMatchersBuilder().ofSubTypes(new String[]{"java.lang.Thread"}).names(new String[]{"interrupt"}).addWithoutParametersMatcher().build();

        public BlockVisitor() {
            this.catchedException = null;
        }

        public BlockVisitor(Symbol catchedException) {
            this.catchedException = catchedException;
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            BlockTree block;
            if (this.threadInterrupted || INTERRUPT_MATCHERS.matches(tree)) {
                this.threadInterrupted = true;
                return;
            }
            ++this.depth;
            Tree declaration = tree.symbol().declaration();
            if (declaration != null && this.depth <= 3 && (block = ((MethodTree)declaration).block()) != null) {
                block.accept((TreeVisitor)this);
            }
            --this.depth;
            super.visitMethodInvocation(tree);
        }

        public void visitThrowStatement(ThrowStatementTree tree) {
            if (this.threadInterrupted || tree.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && ((IdentifierTree)tree.expression()).symbol().equals(this.catchedException)) {
                this.threadInterrupted = true;
                return;
            }
            super.visitThrowStatement(tree);
        }
    }
}

