/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1161")
public class OverrideAnnotationCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (OverrideAnnotationCheck.isExcludedByVersion(this.context.getJavaVersion())) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        Symbol.MethodSymbol methodSymbol = methodTree.symbol();
        List overriddenSymbols = methodSymbol.overriddenSymbols();
        if (overriddenSymbols.isEmpty()) {
            return;
        }
        Symbol.MethodSymbol overriddenSymbol = (Symbol.MethodSymbol)overriddenSymbols.get(0);
        if (!(overriddenSymbol.isAbstract() || OverrideAnnotationCheck.isObjectMethod(overriddenSymbol) || OverrideAnnotationCheck.isAnnotatedOverride(methodSymbol))) {
            this.reportIssue((Tree)methodTree.simpleName(), "Add the \"@Override\" annotation above this method signature");
        }
    }

    private static boolean isExcludedByVersion(JavaVersion javaVersion) {
        if (javaVersion.isNotSet()) {
            return false;
        }
        return javaVersion.asInt() <= 4;
    }

    private static boolean isObjectMethod(Symbol.MethodSymbol method) {
        return method.owner().type().is("java.lang.Object");
    }

    private static boolean isAnnotatedOverride(Symbol.MethodSymbol method) {
        return method.metadata().isAnnotatedWith("java.lang.Override");
    }
}

