/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.collections.SetUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6213")
public class RestrictedIdentifiersUsageCheck
extends IssuableSubscriptionVisitor {
    private static final Set<String> RESTRICTED_IDENTIFIERS = SetUtils.immutableSetOf((Object[])new String[]{"var", "record", "yield"});
    private static final String MESSAGE = "Rename this %s to not match a restricted identifier.";

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.VARIABLE, Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            VariableTree variableTree = (VariableTree)tree;
            IdentifierTree identifierTree = variableTree.simpleName();
            this.reportRestrictedIdentifier(identifierTree, "variable");
        } else {
            MethodTree methodTree = (MethodTree)tree;
            IdentifierTree identifierTree = methodTree.simpleName();
            this.reportRestrictedIdentifier(identifierTree, "method");
        }
    }

    private void reportRestrictedIdentifier(IdentifierTree identifierTree, String method) {
        if (RESTRICTED_IDENTIFIERS.contains(identifierTree.name())) {
            this.reportIssue((Tree)identifierTree, String.format(MESSAGE, method));
        }
    }
}

