/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1118")
public class UtilityClassWithPublicConstructorCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (!UtilityClassWithPublicConstructorCheck.isUtilityClass(classTree) || UtilityClassWithPublicConstructorCheck.isPrivateInnerClass(classTree)) {
            return;
        }
        boolean hasImplicitPublicConstructor = true;
        for (MethodTree explicitConstructor : UtilityClassWithPublicConstructorCheck.getExplicitConstructors(classTree)) {
            hasImplicitPublicConstructor = false;
            if (!UtilityClassWithPublicConstructorCheck.isPublicConstructor((Tree)explicitConstructor)) continue;
            this.reportIssue((Tree)explicitConstructor.simpleName(), "Hide this public constructor.");
        }
        if (hasImplicitPublicConstructor) {
            this.reportIssue((Tree)classTree.simpleName(), "Add a private constructor to hide the implicit public one.");
        }
    }

    private static boolean isPrivateInnerClass(ClassTree classTree) {
        return !classTree.symbol().owner().isPackageSymbol() && ModifiersUtils.hasModifier((ModifiersTree)classTree.modifiers(), (Modifier)Modifier.PRIVATE);
    }

    private static boolean isUtilityClass(ClassTree classTree) {
        return UtilityClassWithPublicConstructorCheck.hasOnlyStaticMembers(classTree) && !UtilityClassWithPublicConstructorCheck.anonymousClass(classTree) && !UtilityClassWithPublicConstructorCheck.extendsAnotherClassOrImplementsSerializable(classTree) && !UtilityClassWithPublicConstructorCheck.containsMainMethod(classTree);
    }

    private static boolean containsMainMethod(ClassTree classTree) {
        return classTree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.METHOD})).anyMatch(method -> MethodTreeUtils.isMainMethod((MethodTree)method));
    }

    private static boolean anonymousClass(ClassTree classTree) {
        return classTree.simpleName() == null;
    }

    private static boolean extendsAnotherClassOrImplementsSerializable(ClassTree classTree) {
        return classTree.superClass() != null || classTree.symbol().type().isSubtypeOf("java.io.Serializable");
    }

    private static boolean hasOnlyStaticMembers(ClassTree classTree) {
        List members = classTree.members();
        if (UtilityClassWithPublicConstructorCheck.noStaticMember(members)) {
            return false;
        }
        return members.stream().allMatch(member -> UtilityClassWithPublicConstructorCheck.isConstructor(member) || UtilityClassWithPublicConstructorCheck.isStatic(member) || member.is(new Tree.Kind[]{Tree.Kind.EMPTY_STATEMENT}));
    }

    private static boolean noStaticMember(List<Tree> members) {
        return members.stream().noneMatch(UtilityClassWithPublicConstructorCheck::isStatic);
    }

    private static boolean isStatic(Tree member) {
        if (member.is(new Tree.Kind[]{Tree.Kind.STATIC_INITIALIZER})) {
            return true;
        }
        if (member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            VariableTree variableTree = (VariableTree)member;
            return UtilityClassWithPublicConstructorCheck.hasStaticModifier(variableTree.modifiers());
        }
        if (member.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            MethodTree methodTree = (MethodTree)member;
            return UtilityClassWithPublicConstructorCheck.hasStaticModifier(methodTree.modifiers());
        }
        if (UtilityClassWithPublicConstructorCheck.isClassTree(member)) {
            ClassTree classTree = (ClassTree)member;
            return UtilityClassWithPublicConstructorCheck.hasStaticModifier(classTree.modifiers());
        }
        return false;
    }

    private static boolean isClassTree(Tree member) {
        return member.is(new Tree.Kind[]{Tree.Kind.CLASS}) || member.is(new Tree.Kind[]{Tree.Kind.ANNOTATION_TYPE}) || member.is(new Tree.Kind[]{Tree.Kind.INTERFACE}) || member.is(new Tree.Kind[]{Tree.Kind.ENUM});
    }

    private static boolean hasStaticModifier(ModifiersTree modifiers) {
        return ModifiersUtils.hasModifier((ModifiersTree)modifiers, (Modifier)Modifier.STATIC);
    }

    private static List<MethodTree> getExplicitConstructors(ClassTree classTree) {
        return Collections.unmodifiableList(classTree.members().stream().filter(UtilityClassWithPublicConstructorCheck::isConstructor).map(MethodTree.class::cast).collect(Collectors.toList()));
    }

    private static boolean isConstructor(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR});
    }

    private static boolean isPublicConstructor(Tree tree) {
        return UtilityClassWithPublicConstructorCheck.isConstructor(tree) && UtilityClassWithPublicConstructorCheck.hasPublicModifier((MethodTree)tree);
    }

    private static boolean hasPublicModifier(MethodTree methodTree) {
        return ModifiersUtils.hasModifier((ModifiersTree)methodTree.modifiers(), (Modifier)Modifier.PUBLIC);
    }
}

