/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2208")
public class WildcardImportsShouldNotBeUsedCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.IMPORT);
    }

    public void visitNode(Tree tree) {
        ImportTree importTree = (ImportTree)tree;
        if (WildcardImportsShouldNotBeUsedCheck.fullQualifiedName(importTree.qualifiedIdentifier()).endsWith(".*") && !importTree.isStatic()) {
            this.reportIssue(importTree.qualifiedIdentifier(), "Explicitly import the specific classes needed.");
        }
    }

    private static String fullQualifiedName(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return ((IdentifierTree)tree).name();
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree m = (MemberSelectExpressionTree)tree;
            return WildcardImportsShouldNotBeUsedCheck.fullQualifiedName((Tree)m.expression()) + "." + m.identifier().name();
        }
        throw new UnsupportedOperationException(String.format("Kind/Class '%s' not supported", tree.getClass()));
    }
}

