/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.unused;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.UnresolvedIdentifiersVisitor;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1481")
public class UnusedLocalVariableCheck
extends IssuableSubscriptionVisitor {
    private static final Tree.Kind[] INCREMENT_KINDS = new Tree.Kind[]{Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT};
    private static final String MESSAGE = "Remove this unused \"%s\" local variable.";
    private static final UnresolvedIdentifiersVisitor UNRESOLVED_IDENTIFIERS_VISITOR = new UnresolvedIdentifiersVisitor();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.COMPILATION_UNIT, Tree.Kind.VARIABLE);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.COMPILATION_UNIT})) {
            UNRESOLVED_IDENTIFIERS_VISITOR.check(tree);
        }
    }

    public void leaveNode(Tree tree) {
        VariableTree variable;
        String name;
        boolean unresolved;
        if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && !(unresolved = UNRESOLVED_IDENTIFIERS_VISITOR.isUnresolved(name = (variable = (VariableTree)tree).simpleName().name())) && UnusedLocalVariableCheck.isProperLocalVariable(variable) && UnusedLocalVariableCheck.isUnused(variable.symbol())) {
            this.reportIssue((Tree)variable.simpleName(), String.format(MESSAGE, name));
        }
    }

    private static boolean isUnused(Symbol symbol) {
        return symbol.usages().stream().noneMatch(UnusedLocalVariableCheck::isRValue);
    }

    private static boolean isRValue(IdentifierTree tree) {
        Tree parent = UnusedLocalVariableCheck.skipParenthesesUpwards(tree.parent());
        if (parent instanceof AssignmentExpressionTree) {
            AssignmentExpressionTree assignment = (AssignmentExpressionTree)parent;
            return assignment.variable() != tree;
        }
        return !parent.is(INCREMENT_KINDS) || !parent.parent().is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT});
    }

    private static Tree skipParenthesesUpwards(Tree tree) {
        while (tree.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) {
            tree = tree.parent();
        }
        return tree;
    }

    private static boolean isProperLocalVariable(VariableTree variable) {
        Symbol symbol = variable.symbol();
        return JUtils.isLocalVariable((Symbol)symbol) && !JUtils.isParameter((Symbol)symbol) && !UnusedLocalVariableCheck.isDefinedInCatchClause(variable) && !UnusedLocalVariableCheck.isTryResource(variable);
    }

    private static boolean isDefinedInCatchClause(VariableTree variable) {
        return variable.parent().is(new Tree.Kind[]{Tree.Kind.CATCH});
    }

    private static boolean isTryResource(VariableTree variable) {
        return variable.parent().is(new Tree.Kind[]{Tree.Kind.LIST}) && variable.parent().parent().is(new Tree.Kind[]{Tree.Kind.TRY_STATEMENT});
    }
}

