/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.filters;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.sonar.api.scan.issue.filter.FilterableIssue;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.check.Rule;
import org.sonar.java.filters.JavaIssueFilter;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

public abstract class BaseTreeVisitorIssueFilter
extends BaseTreeVisitor
implements JavaIssueFilter {
    private String componentKey;
    private final Map<String, Set<Integer>> excludedLinesByRule = new HashMap<String, Set<Integer>>();
    private final Map<Class<? extends JavaCheck>, String> rulesKeysByRulesClass = BaseTreeVisitorIssueFilter.rulesKeysByRulesClass(this.filteredRules());

    protected BaseTreeVisitorIssueFilter() {
    }

    private static Map<Class<? extends JavaCheck>, String> rulesKeysByRulesClass(Set<Class<? extends JavaCheck>> rules) {
        HashMap<Class<? extends JavaCheck>, String> results = new HashMap<Class<? extends JavaCheck>, String>();
        for (Class<? extends JavaCheck> ruleClass : rules) {
            Rule ruleAnnotation = (Rule)AnnotationUtils.getAnnotation(ruleClass, Rule.class);
            if (ruleAnnotation == null) continue;
            results.put(ruleClass, ruleAnnotation.key());
        }
        return results;
    }

    public String getComponentKey() {
        return this.componentKey;
    }

    public void scanFile(JavaFileScannerContext context) {
        this.componentKey = context.getInputFile().key();
        this.excludedLinesByRule.clear();
        this.scan((Tree)context.getTree());
    }

    @Override
    public boolean accept(FilterableIssue issue) {
        return !issue.componentKey().equals(this.componentKey) || !((Set)this.excludedLinesByRule.getOrDefault(issue.ruleKey().rule(), new HashSet())).contains(issue.line());
    }

    public Map<String, Set<Integer>> excludedLinesByRule() {
        return this.excludedLinesByRule;
    }

    public void acceptLines(@Nullable Tree tree, Iterable<Class<? extends JavaCheck>> rules) {
        for (Class<? extends JavaCheck> rule : rules) {
            this.acceptLines(tree, rule);
        }
    }

    public void acceptLines(@Nullable Tree tree, Class<? extends JavaCheck> rule) {
        this.computeFilteredLinesForRule(tree, rule, false);
    }

    public void excludeLines(@Nullable Tree tree, Iterable<Class<? extends JavaCheck>> rules) {
        for (Class<? extends JavaCheck> rule : rules) {
            this.excludeLines(tree, rule);
        }
    }

    public void excludeLines(Set<Integer> lines, String ruleKey) {
        this.computeFilteredLinesForRule(lines, ruleKey, true);
    }

    public void excludeLines(@Nullable Tree tree, Class<? extends JavaCheck> rule) {
        this.computeFilteredLinesForRule(tree, rule, true);
    }

    private void computeFilteredLinesForRule(@Nullable Tree tree, Class<? extends JavaCheck> filteredRule, boolean excludeLine) {
        if (tree == null) {
            return;
        }
        SyntaxToken firstSyntaxToken = tree.firstToken();
        SyntaxToken lastSyntaxToken = tree.lastToken();
        if (firstSyntaxToken != null && lastSyntaxToken != null) {
            Set<Integer> filteredLines = IntStream.rangeClosed(firstSyntaxToken.line(), lastSyntaxToken.line()).boxed().collect(Collectors.toSet());
            this.computeFilteredLinesForRule(filteredLines, this.rulesKeysByRulesClass.get(filteredRule), excludeLine);
        }
    }

    private void computeFilteredLinesForRule(Set<Integer> lines, String ruleKey, boolean excludeLine) {
        if (excludeLine) {
            this.excludedLinesByRule.computeIfAbsent(ruleKey, k -> new HashSet()).addAll(lines);
        } else {
            this.excludedLinesByRule.getOrDefault(ruleKey, Collections.emptySet()).removeAll(lines);
        }
    }
}

