/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S899")
public class IgnoredOperationStatusCheck
extends AbstractMethodDetection {
    private static final String FILE = "java.io.File";
    private static final String CONDITION = "java.util.concurrent.locks.Condition";
    private static final String BLOCKING_QUEUE = "java.util.concurrent.BlockingQueue";

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"java.util.concurrent.locks.Lock"}).names(new String[]{"tryLock"}).addWithoutParametersMatcher().build(), MethodMatchers.create().ofTypes(new String[]{FILE}).name(name -> "delete".equals(name) || "exists".equals(name) || "createNewFile".equals(name) || name.startsWith("can") || name.startsWith("is")).addWithoutParametersMatcher().build(), MethodMatchers.create().ofTypes(new String[]{FILE}).name(name -> name.startsWith("set")).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{FILE}).names(new String[]{"renameTo"}).addParametersMatcher(new String[]{FILE}).build(), MethodMatchers.create().ofSubTypes(new String[]{"java.util.Iterator"}).names(new String[]{"hasNext"}).addWithoutParametersMatcher().build(), MethodMatchers.create().ofSubTypes(new String[]{"java.util.Enumeration"}).names(new String[]{"hasMoreElements"}).addWithoutParametersMatcher().build(), MethodMatchers.create().ofSubTypes(new String[]{CONDITION}).names(new String[]{"await"}).addParametersMatcher(new String[]{"long", "java.util.concurrent.TimeUnit"}).build(), MethodMatchers.create().ofSubTypes(new String[]{CONDITION}).names(new String[]{"awaitUntil"}).addParametersMatcher(new String[]{"java.util.Date"}).build(), MethodMatchers.create().ofSubTypes(new String[]{CONDITION}).names(new String[]{"awaitNanos"}).addParametersMatcher(new String[]{"long"}).build(), MethodMatchers.create().ofTypes(new String[]{"java.util.concurrent.CountDownLatch"}).names(new String[]{"await"}).addParametersMatcher(new String[]{"long", "java.util.concurrent.TimeUnit"}).build(), MethodMatchers.create().ofTypes(new String[]{"java.util.concurrent.Semaphore"}).names(new String[]{"tryAcquire"}).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{BLOCKING_QUEUE}).names(new String[]{"offer"}).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{BLOCKING_QUEUE}).names(new String[]{"remove"}).withAnyParameters().build()});
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        Tree parent = mit.parent();
        if (parent.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT}) || parent.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && ((VariableTree)parent).symbol().usages().isEmpty()) {
            this.reportIssue(parent, "Do something with the \"" + mit.symbolType().name() + "\" value returned by \"" + mit.methodSymbol().name() + "\".");
        }
    }
}

