/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;

public abstract class AbstractRegexCheckTrackingMatchers
extends AbstractRegexCheck {
    private static final String JAVA_UTIL_REGEX_PATTERN = "java.util.regex.Pattern";
    private static final String JAVA_UTIL_REGEX_MATCHER = "java.util.regex.Matcher";
    private static final MethodMatchers PATTERN_MATCHER = MethodMatchers.create().ofTypes(new String[]{"java.util.regex.Pattern"}).names(new String[]{"matcher"}).addParametersMatcher(new String[]{"java.lang.CharSequence"}).build();
    private static final MethodMatchers PATTERN_COMPILE = MethodMatchers.create().ofTypes(new String[]{"java.util.regex.Pattern"}).names(new String[]{"compile"}).withAnyParameters().build();
    private static final MethodMatchers PATTERN_OR_MATCHER_ARGUMENT = MethodMatchers.create().ofAnyType().anyName().addParametersMatcher(types -> types.stream().anyMatch(AbstractRegexCheckTrackingMatchers::isPatternOrMatcher)).build();
    private final MethodMatchers matchers = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{REGEX_METHODS, PATTERN_MATCHER, PATTERN_OR_MATCHER_ARGUMENT, this.trackedMethodMatchers()});
    private final Map<Symbol, RegexParseResult> variableToRegex = new HashMap<Symbol, RegexParseResult>();
    private final Map<MethodInvocationTree, RegexParseResult> methodInvocationToRegex = new HashMap<MethodInvocationTree, RegexParseResult>();
    private final Map<RegexParseResult, List<MethodInvocationTree>> methodsCalledOnRegex = new LinkedHashMap<RegexParseResult, List<MethodInvocationTree>>();
    private final Map<RegexParseResult, ExpressionTree> regexCreations = new HashMap<RegexParseResult, ExpressionTree>();
    private final Set<RegexParseResult> escapingRegexes = new HashSet<RegexParseResult>();

    protected abstract MethodMatchers trackedMethodMatchers();

    protected abstract void checkRegex(RegexParseResult var1, ExpressionTree var2, List<MethodInvocationTree> var3, boolean var4);

    private static boolean isPatternOrMatcher(Type type) {
        String name = type.fullyQualifiedName();
        return name.equals(JAVA_UTIL_REGEX_PATTERN) || name.equals(JAVA_UTIL_REGEX_MATCHER);
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        ArrayList<Tree.Kind> nodes = new ArrayList<Tree.Kind>(super.nodesToVisit());
        nodes.add(Tree.Kind.NEW_CLASS);
        nodes.add(Tree.Kind.RETURN_STATEMENT);
        nodes.add(Tree.Kind.COMPILATION_UNIT);
        return nodes;
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
            this.collectReturnedVariables(((ReturnStatementTree)tree).expression());
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.COMPILATION_UNIT})) {
            this.methodsCalledOnRegex.forEach((regex, invocation) -> this.checkRegex((RegexParseResult)regex, this.regexCreations.get(regex), (List<MethodInvocationTree>)invocation, this.escapingRegexes.contains(regex)));
            this.variableToRegex.clear();
            this.methodInvocationToRegex.clear();
            this.methodsCalledOnRegex.clear();
            this.escapingRegexes.clear();
            this.regexCreations.clear();
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && this.matchers.matches((MethodInvocationTree)tree)) {
            this.onMethodInvocationFound((MethodInvocationTree)tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            if (PATTERN_OR_MATCHER_ARGUMENT.matches((NewClassTree)tree)) {
                this.onConstructorFound((NewClassTree)tree);
            }
        } else {
            super.visitNode(tree);
        }
    }

    private void collectReturnedVariables(@Nullable ExpressionTree returnedExpression) {
        if (returnedExpression == null) {
            return;
        }
        this.getRegex(returnedExpression).ifPresent(this.escapingRegexes::add);
    }

    @Override
    public void visitNode(Tree tree) {
    }

    private void onConstructorFound(NewClassTree tree) {
        for (ExpressionTree argument : tree.arguments()) {
            this.getRegex(argument).ifPresent(this.escapingRegexes::add);
        }
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (PATTERN_MATCHER.matches(mit)) {
            this.getRegex((ExpressionTree)mit).ifPresent(regex -> this.handleAssignment(mit, (RegexParseResult)regex));
        } else if (REGEX_METHODS.matches(mit)) {
            super.onMethodInvocationFound(mit);
        } else if (this.trackedMethodMatchers().matches(mit)) {
            this.getRegex((ExpressionTree)mit).ifPresent(regex -> this.methodsCalledOnRegex.get(regex).add(mit));
        } else {
            for (ExpressionTree argument : mit.arguments()) {
                this.getRegex(argument).ifPresent(this.escapingRegexes::add);
            }
        }
    }

    private Optional<RegexParseResult> getRegex(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            if (PATTERN_MATCHER.matches(mit) || this.trackedMethodMatchers().matches(mit)) {
                return this.getRegexOperand(mit);
            }
            return Optional.ofNullable(this.methodInvocationToRegex.get(tree));
        }
        return ExpressionUtils.extractIdentifierSymbol((ExpressionTree)tree).flatMap(symbol -> Optional.ofNullable(this.variableToRegex.get(symbol)));
    }

    private Optional<RegexParseResult> getRegexOperand(MethodInvocationTree mit) {
        ExpressionTree object;
        if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && AbstractRegexCheckTrackingMatchers.isPatternOrMatcher((object = ((MemberSelectExpressionTree)mit.methodSelect()).expression()).symbolType())) {
            return this.getRegex(object);
        }
        return mit.arguments().stream().filter(arg -> AbstractRegexCheckTrackingMatchers.isPatternOrMatcher(arg.symbolType())).map(this::getRegex).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    @Override
    public void checkRegex(RegexParseResult regexForLiterals, ExpressionTree methodInvocationOrAnnotation) {
        this.regexCreations.put(regexForLiterals, methodInvocationOrAnnotation);
        if (methodInvocationOrAnnotation.is(new Tree.Kind[]{Tree.Kind.ANNOTATION})) {
            this.methodsCalledOnRegex.put(regexForLiterals, new ArrayList());
            return;
        }
        MethodInvocationTree mit = (MethodInvocationTree)methodInvocationOrAnnotation;
        if (PATTERN_COMPILE.matches(mit)) {
            this.handleAssignment(mit, regexForLiterals);
            this.methodInvocationToRegex.put(mit, regexForLiterals);
            this.methodsCalledOnRegex.put(regexForLiterals, new ArrayList());
        } else if (this.trackedMethodMatchers().matches(mit)) {
            this.methodsCalledOnRegex.put(regexForLiterals, new ArrayList<MethodInvocationTree>(Collections.singletonList(mit)));
        } else {
            this.methodsCalledOnRegex.put(regexForLiterals, new ArrayList());
        }
    }

    private void handleAssignment(MethodInvocationTree mit, RegexParseResult regex) {
        Tree grandParent;
        Tree parent = mit.parent();
        if (parent.is(new Tree.Kind[]{Tree.Kind.VARIABLE, Tree.Kind.ASSIGNMENT})) {
            Optional<Symbol> assignedVariable = AbstractRegexCheckTrackingMatchers.getAssignedPrivateEffectivelyFinalVariable(mit);
            if (assignedVariable.isPresent()) {
                this.variableToRegex.put(assignedVariable.get(), regex);
            } else {
                this.escapingRegexes.add(regex);
            }
        } else if (!(!parent.is(new Tree.Kind[]{Tree.Kind.ARGUMENTS}) || (grandParent = parent.parent()).is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && this.trackedMethodMatchers().matches((MethodInvocationTree)grandParent))) {
            this.escapingRegexes.add(regex);
        }
    }

    private static boolean isPrivateEffectivelyFinalVariable(Symbol symbol) {
        return !(!symbol.isPrivate() && !symbol.owner().isMethodSymbol() || !symbol.isVariableSymbol() || !symbol.isFinal() && !JUtils.isEffectivelyFinal((Symbol.VariableSymbol)((Symbol.VariableSymbol)symbol)));
    }

    private static Optional<Symbol> getAssignedPrivateEffectivelyFinalVariable(MethodInvocationTree mit) {
        Tree parent = mit.parent();
        Symbol symbol = null;
        if (parent.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            symbol = ((VariableTree)parent).symbol();
        } else if (parent.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            MemberSelectExpressionTree mset;
            ExpressionTree variable = ((AssignmentExpressionTree)parent).variable();
            if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                symbol = ((IdentifierTree)variable).symbol();
            } else if (variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && ExpressionUtils.isSelectOnThisOrSuper((MemberSelectExpressionTree)(mset = (MemberSelectExpressionTree)variable))) {
                symbol = mset.identifier().symbol();
            }
        }
        return Optional.ofNullable(symbol).filter(AbstractRegexCheckTrackingMatchers::isPrivateEffectivelyFinalVariable);
    }
}

