/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.check.Rule;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.checks.helpers.CredentialMethod;
import org.sonar.java.checks.helpers.CredentialMethodsLoader;
import org.sonar.java.checks.helpers.HardcodedStringExpressionChecker;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6437")
public class HardCodedCredentialsShouldNotBeUsedCheck
extends IssuableSubscriptionVisitor {
    public static final String CREDENTIALS_METHODS_FILE = "/org/sonar/java/checks/security/S6437-methods.json";
    private static final Logger LOG = LoggerFactory.getLogger(HardCodedCredentialsShouldNotBeUsedCheck.class);
    private static final String ISSUE_MESSAGE = "Revoke and change this password, as it is compromised.";
    private Map<String, List<CredentialMethod>> methods;

    public HardCodedCredentialsShouldNotBeUsedCheck() {
        this(CREDENTIALS_METHODS_FILE);
    }

    @VisibleForTesting
    HardCodedCredentialsShouldNotBeUsedCheck(String resourcePath) {
        try {
            this.methods = CredentialMethodsLoader.load(resourcePath);
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            this.methods = Collections.emptyMap();
        }
    }

    public Map<String, List<CredentialMethod>> getMethods() {
        return this.methods;
    }

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        String methodName;
        boolean isConstructor = tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS});
        if (isConstructor) {
            NewClassTree newClass = (NewClassTree)tree;
            methodName = newClass.symbolType().name();
        } else {
            MethodInvocationTree invocation = (MethodInvocationTree)tree;
            methodName = invocation.methodSymbol().name();
        }
        List<CredentialMethod> candidates = this.methods.get(methodName);
        if (candidates == null) {
            return;
        }
        for (CredentialMethod candidate : candidates) {
            MethodMatchers matcher = candidate.methodMatcher();
            if (isConstructor) {
                NewClassTree constructor = (NewClassTree)tree;
                if (!matcher.matches(constructor)) continue;
                this.checkArguments(constructor.arguments(), candidate);
                continue;
            }
            MethodInvocationTree invocation = (MethodInvocationTree)tree;
            if (!matcher.matches(invocation)) continue;
            this.checkArguments(invocation.arguments(), candidate);
        }
    }

    private void checkArguments(Arguments arguments, CredentialMethod method) {
        for (int targetArgumentIndex : method.indices) {
            ArrayList<JavaFileScannerContext.Location> secondaryLocations;
            ExpressionTree argument = (ExpressionTree)arguments.get(targetArgumentIndex);
            if (!HardcodedStringExpressionChecker.isExpressionDerivedFromPlainText(argument, secondaryLocations = new ArrayList<JavaFileScannerContext.Location>(), new HashSet<Symbol>())) continue;
            this.reportIssue((Tree)argument, ISSUE_MESSAGE, secondaryLocations, null);
        }
    }
}

