/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6804")
public class ValueAnnotationShouldInjectPropertyOrSpELCheck
extends IssuableSubscriptionVisitor {
    private static final String SPRING_VALUE = "org.springframework.beans.factory.annotation.Value";

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.CLASS, Tree.Kind.ANNOTATION_TYPE);
    }

    public void visitNode(Tree tree) {
        ClassTree cls = (ClassTree)tree;
        List fieldsAnnotations = cls.members().stream().filter(m -> m.is(new Tree.Kind[]{Tree.Kind.VARIABLE})).flatMap(field -> ((VariableTree)field).modifiers().annotations().stream()).collect(Collectors.toList());
        List interfaceAnnotations = cls.is(new Tree.Kind[]{Tree.Kind.ANNOTATION_TYPE}) ? cls.modifiers().annotations() : List.of();
        Stream.concat(fieldsAnnotations.stream(), interfaceAnnotations.stream()).filter(ValueAnnotationShouldInjectPropertyOrSpELCheck::isSimpleSpringValue).forEach(ann -> this.reportIssue((Tree)ann, "Either replace the \"@Value\" annotation with a standard field initialization, use \"${propertyName}\" to inject a property or use \"#{expression}\" to evaluate a SpEL expression."));
    }

    private static boolean isSimpleSpringValue(AnnotationTree ann) {
        if (ann.symbolType().is(SPRING_VALUE)) {
            LiteralTree literal = (LiteralTree)ann.arguments().get(0);
            String value = literal.value();
            return !ValueAnnotationShouldInjectPropertyOrSpELCheck.isPropertyName(value) && !ValueAnnotationShouldInjectPropertyOrSpELCheck.isSpEL(value);
        }
        return false;
    }

    private static boolean isPropertyName(String value) {
        return value.startsWith("\"${") && value.endsWith("}\"");
    }

    private static boolean isSpEL(String value) {
        return value.startsWith("\"#{") && value.endsWith("}\"");
    }
}

