/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6126")
public class StringConcatToTextBlockCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    private static final String MESSAGE = "Replace this String concatenation with Text block.";
    public static final int MINIMAL_CONTENT_LENGTH = 19;
    public static final int MINIMAL_NUMBER_OF_LINES = 2;
    public static final Pattern EOL = Pattern.compile("(?<!\\\\)\\\\n");
    private final Set<Tree> visitedNodes = new HashSet<Tree>();

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava15Compatible();
    }

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.PLUS);
    }

    public void visitNode(Tree tree) {
        String content;
        if (this.visitedNodes.contains(tree)) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        if (this.concatStringLiterals(builder, tree) && (content = builder.toString()).length() >= 19 && StringConcatToTextBlockCheck.isMultiline(content)) {
            this.reportIssue(tree, MESSAGE);
        }
    }

    private static boolean isMultiline(String line) {
        int matches;
        Matcher matcher = EOL.matcher(line);
        for (matches = 0; matcher.find() && matches < 2; ++matches) {
        }
        return matches == 2;
    }

    private boolean concatStringLiterals(StringBuilder concatenatedContent, Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.PLUS})) {
            BinaryExpressionTree binaryExpression = (BinaryExpressionTree)tree;
            this.visitedNodes.add((Tree)binaryExpression);
            return this.concatStringLiterals(concatenatedContent, (Tree)ExpressionUtils.skipParentheses((ExpressionTree)binaryExpression.leftOperand())) && this.concatStringLiterals(concatenatedContent, (Tree)ExpressionUtils.skipParentheses((ExpressionTree)binaryExpression.rightOperand()));
        }
        if (tree instanceof LiteralTree) {
            String treeValue = LiteralUtils.getAsStringValue((LiteralTree)((LiteralTree)tree));
            concatenatedContent.append(treeValue);
            return true;
        }
        return false;
    }

    public void setContext(JavaFileScannerContext context) {
        this.visitedNodes.clear();
        super.setContext(context);
    }
}

