/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.java.model.DefaultJavaFileScannerContext;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.SwitchTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6208")
public class SwitchCasesShouldBeCommaSeparatedCheck
extends SubscriptionVisitor
implements JavaVersionAwareVisitor {
    private static final String MESSAGE = "Merge the previous cases into this one using comma-separated label.";

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.SWITCH_EXPRESSION, Tree.Kind.SWITCH_STATEMENT);
    }

    public void visitNode(Tree tree) {
        SwitchTree switchExpression = (SwitchTree)tree;
        if (!SwitchCasesShouldBeCommaSeparatedCheck.usesColons(switchExpression)) {
            return;
        }
        for (CaseGroupTree aCase : switchExpression.cases()) {
            Deque caseLabels;
            List labels = aCase.labels();
            int size = labels.size();
            if (size == 1 || (caseLabels = (Deque)labels.stream().filter(label -> "case".equals(label.caseOrDefaultKeyword().text())).collect(Collectors.toCollection(ArrayDeque::new))).size() <= 1) continue;
            CaseLabelTree lastLabel = (CaseLabelTree)caseLabels.removeLast();
            ((DefaultJavaFileScannerContext)this.context).newIssue().forRule((JavaCheck)this).onTree((Tree)lastLabel).withMessage(MESSAGE).withSecondaries(caseLabels.stream().map(label -> new JavaFileScannerContext.Location("", (Tree)label)).collect(Collectors.toList())).report();
        }
        super.visitNode(tree);
    }

    public static boolean usesColons(SwitchTree tree) {
        return !tree.cases().isEmpty() && ":".equals(((CaseLabelTree)((CaseGroupTree)tree.cases().get(0)).labels().get(0)).colonOrArrowToken().text());
    }

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return 14 <= version.asInt();
    }
}

