/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1217")
public class ThreadRunCheck
extends AbstractMethodDetection {
    private static final MethodMatchers THREAD_RUN_METHOD_MATCHER = MethodMatchers.create().ofSubTypes(new String[]{"java.lang.Thread"}).names(new String[]{"run"}).withAnyParameters().build();

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return THREAD_RUN_METHOD_MATCHER;
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        Tree parent;
        for (parent = mit.parent(); parent != null && !parent.is(new Tree.Kind[]{Tree.Kind.METHOD}); parent = parent.parent()) {
        }
        if (parent != null && THREAD_RUN_METHOD_MATCHER.matches((MethodTree)parent)) {
            return;
        }
        IdentifierTree methodName = ExpressionUtils.methodName((MethodInvocationTree)mit);
        QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)methodName).withMessage("Call the method Thread.start() to execute the content of the run() method in a dedicated thread.").withQuickFix(() -> ThreadRunCheck.computeQuickFix(methodName)).report();
    }

    private static JavaQuickFix computeQuickFix(IdentifierTree methodName) {
        return JavaQuickFix.newQuickFix((String)"Replace run() with start()").addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTree((Tree)methodName, (String)"start")}).build();
    }
}

