/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.filters;

import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.sonar.java.checks.AbstractClassNoFieldShouldBeInterfaceCheck;
import org.sonar.java.checks.EqualsNotOverridenWithCompareToCheck;
import org.sonar.java.checks.EqualsOverridenWithHashCodeCheck;
import org.sonar.java.filters.BaseTreeVisitorIssueFilter;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;

public class GoogleAutoFilter
extends BaseTreeVisitorIssueFilter {
    private static final Set<Class<? extends JavaCheck>> FILTERED_RULES = Set.of(EqualsOverridenWithHashCodeCheck.class, EqualsNotOverridenWithCompareToCheck.class, AbstractClassNoFieldShouldBeInterfaceCheck.class);
    private static final String AUTO_VALUE_ANNOTATION = "com.google.auto.value.AutoValue";
    private static final List<String> AUTO_ANNOTATIONS = List.of("com.google.auto.value.AutoValue$Builder", "com.google.auto.value.AutoOneOf");

    @Override
    public Set<Class<? extends JavaCheck>> filteredRules() {
        return FILTERED_RULES;
    }

    /*
     * Unable to fully structure code
     */
    public void visitClass(ClassTree tree) {
        classMetadata = tree.symbol().metadata();
        isAnnotatedWithAutoValue = classMetadata.isAnnotatedWith("com.google.auto.value.AutoValue");
        this.excludeLinesIfTrue(isAnnotatedWithAutoValue, (Tree)tree, new Class[]{EqualsOverridenWithHashCodeCheck.class, EqualsNotOverridenWithCompareToCheck.class});
        if (isAnnotatedWithAutoValue) ** GOTO lbl-1000
        if (GoogleAutoFilter.AUTO_ANNOTATIONS.stream().anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isAnnotatedWith(java.lang.String ), (Ljava/lang/String;)Z)((SymbolMetadata)classMetadata))) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        this.excludeLinesIfTrue(v0, (Tree)tree.simpleName(), (Class<? extends JavaCheck>)AbstractClassNoFieldShouldBeInterfaceCheck.class);
        super.visitClass(tree);
    }
}

