/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.helpers.UnitTestUtils;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.PackageDeclarationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5960")
public class AssertionsInProductionCodeCheck
extends AbstractMethodDetection {
    private static final Pattern TEST_PACKAGE_REGEX = Pattern.compile("test|junit|assert");
    private final List<Tree> assertions = new ArrayList<Tree>();
    private boolean packageNameNotRelatedToTests = true;

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.PACKAGE);
    }

    protected MethodMatchers getMethodInvocationMatchers() {
        return UnitTestUtils.COMMON_ASSERTION_MATCHER;
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.PACKAGE})) {
            String packageName = ExpressionsHelper.concatenate((ExpressionTree)((PackageDeclarationTree)tree).packageName());
            boolean bl = this.packageNameNotRelatedToTests = !TEST_PACKAGE_REGEX.matcher(packageName).find();
        }
        if (this.packageNameNotRelatedToTests) {
            super.visitNode(tree);
        }
    }

    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.assertions.add((Tree)mit);
    }

    public void setContext(JavaFileScannerContext context) {
        super.setContext(context);
        this.assertions.clear();
        this.packageNameNotRelatedToTests = true;
    }

    public void leaveFile(JavaFileScannerContext context) {
        if (!this.assertions.isEmpty()) {
            Tree primaryLocation = this.assertions.get(0);
            List secondaryLocations = this.assertions.stream().skip(1L).map(expr -> new JavaFileScannerContext.Location("Assertion", expr)).collect(Collectors.toList());
            this.reportIssue(primaryLocation, "Remove this assertion from production code.", secondaryLocations, null);
        }
        this.assertions.clear();
        super.leaveFile(context);
    }
}

