/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1193")
public class InstanceofUsedOnExceptionCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CATCH);
    }

    public void visitNode(Tree tree) {
        CatchTree catchTree = (CatchTree)tree;
        String caughtVariable = catchTree.parameter().simpleName().name();
        List body = catchTree.block().body();
        if (body.stream().allMatch(statement -> statement.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT, Tree.Kind.THROW_STATEMENT, Tree.Kind.IF_STATEMENT}))) {
            this.reportSimpleInstanceOf(body, caughtVariable);
        }
    }

    private void reportSimpleInstanceOf(List<StatementTree> body, String caughtVariable) {
        List conditions = body.stream().filter(statement -> statement.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})).map(IfStatementTree.class::cast).flatMap(InstanceofUsedOnExceptionCheck::getFollowingElseIf).map(IfStatementTree::condition).collect(Collectors.toList());
        if (conditions.stream().allMatch(cond -> cond.is(new Tree.Kind[]{Tree.Kind.INSTANCE_OF}) && InstanceofUsedOnExceptionCheck.isLeftOperandAndException((InstanceOfTree)cond, caughtVariable))) {
            conditions.stream().map(InstanceOfTree.class::cast).forEach(instanceOfTree -> this.reportIssue((Tree)instanceOfTree.instanceofKeyword(), "Replace the usage of the \"instanceof\" operator by a catch block."));
        }
    }

    private static boolean isLeftOperandAndException(InstanceOfTree instanceOfTree, String caughtVariable) {
        ExpressionTree expression = instanceOfTree.expression();
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return caughtVariable.equals(((IdentifierTree)expression).name()) && instanceOfTree.type().symbolType().isSubtypeOf("java.lang.Throwable");
        }
        return false;
    }

    private static Stream<IfStatementTree> getFollowingElseIf(IfStatementTree ifStatementTree) {
        ArrayList<IfStatementTree> ifStatements = new ArrayList<IfStatementTree>();
        ifStatements.add(ifStatementTree);
        StatementTree elseStatement = ifStatementTree.elseStatement();
        while (elseStatement != null) {
            if (elseStatement.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
                IfStatementTree elseIfStatement = (IfStatementTree)elseStatement;
                ifStatements.add(elseIfStatement);
                elseStatement = elseIfStatement.elseStatement();
                continue;
            }
            elseStatement = null;
        }
        return ifStatements.stream();
    }
}

