/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6485")
public class KnownCapacityHashBasedCollectionCheck
extends AbstractMethodDetection
implements JavaVersionAwareVisitor {
    private static final Map<String, String> TYPES_TO_METHODS = Map.of("HashMap", "HashMap.newHashMap(int numMappings)", "HashSet", "HashSet.newHashSet(int numMappings)", "LinkedHashMap", "LinkedHashMap.newLinkedHashMap(int numMappings)", "LinkedHashSet", "LinkedHashSet.newLinkedHashSet(int numMappings)", "WeakHashMap", "WeakHashMap.newWeakHashMap(int numMappings)");

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.NEW_CLASS);
    }

    protected void onConstructorFound(NewClassTree newClassTree) {
        this.reportIssue((Tree)newClassTree, KnownCapacityHashBasedCollectionCheck.getIssueMessage(newClassTree));
    }

    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(new String[]{"java.util.HashMap", "java.util.HashSet", "java.util.LinkedHashMap", "java.util.LinkedHashSet", "java.util.WeakHashMap"}).constructor().addParametersMatcher(new String[]{"int"}).build();
    }

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava19Compatible();
    }

    private static String getIssueMessage(NewClassTree newClassTree) {
        String replacementMethod = TYPES_TO_METHODS.get(newClassTree.symbolType().name());
        return String.format("Replace this call to the constructor with the better suited static method %s", replacementMethod);
    }
}

