/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2119")
public class ReuseRandomCheck
extends AbstractMethodDetection {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.NEW_CLASS);
    }

    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(new String[]{"java.util.Random"}).constructor().addWithoutParametersMatcher().build();
    }

    protected void onConstructorFound(NewClassTree newClassTree) {
        if (!ReuseRandomCheck.isInConstructorOrStaticMain((ExpressionTree)newClassTree) && ReuseRandomCheck.isUsedOnlyLocally((Tree)newClassTree)) {
            this.reportIssue((Tree)newClassTree.identifier(), "Save and re-use this \"Random\".");
        }
    }

    private static boolean isInConstructorOrStaticMain(ExpressionTree tree) {
        MethodTree enclosingMethod = ExpressionUtils.getEnclosingMethod((ExpressionTree)tree);
        if (enclosingMethod != null) {
            Symbol.MethodSymbol symbol = enclosingMethod.symbol();
            String name = symbol.name();
            return "<init>".equals(name) || "main".equals(name) && symbol.isStatic();
        }
        return false;
    }

    private static boolean isUsedOnlyLocally(Tree tree) {
        Tree parent = tree.parent();
        if (parent.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            return ReuseRandomCheck.isLocalVariable(((AssignmentExpressionTree)parent).variable()) && ReuseRandomCheck.isUsedOnlyLocally(parent);
        }
        if (parent.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            return ReuseRandomCheck.isLocalVariable((ExpressionTree)((VariableTree)parent).simpleName());
        }
        if (parent.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) {
            return ReuseRandomCheck.isUsedOnlyLocally(parent);
        }
        return parent.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT, Tree.Kind.MEMBER_SELECT});
    }

    private static boolean isLocalVariable(ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return ((IdentifierTree)expression).symbol().isLocalVariable();
        }
        return false;
    }
}

