/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6291")
public class AndroidUnencryptedDatabaseCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String ANDROID_CONTENT_CONTEXT = "android.content.Context";
    private static final String REALM_CONFIGURATION_BUILDER_TYPE = "io.realm.RealmConfiguration$Builder";
    private static final MethodMatchers UNSAFE_DATABASE_CALL = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"android.app.Activity"}).names(new String[]{"getPreferences"}).addParametersMatcher(new String[]{"int"}).build(), MethodMatchers.create().ofSubTypes(new String[]{"android.preference.PreferenceManager"}).names(new String[]{"getDefaultSharedPreferences"}).addParametersMatcher(new String[]{"android.content.Context"}).build(), MethodMatchers.create().ofSubTypes(new String[]{"android.content.Context"}).names(new String[]{"getSharedPreferences"}).addParametersMatcher(new String[]{"java.lang.String", "int"}).addParametersMatcher(new String[]{"java.io.File", "int"}).build(), MethodMatchers.create().ofSubTypes(new String[]{"android.content.Context"}).names(new String[]{"openOrCreateDatabase"}).addParametersMatcher(new String[]{"java.lang.String", "int", "android.database.sqlite.SQLiteDatabase$CursorFactory"}).addParametersMatcher(new String[]{"java.lang.String", "int", "android.database.sqlite.SQLiteDatabase$CursorFactory", "android.database.DatabaseErrorHandler"}).build()});
    private static final MethodMatchers REALM_CONFIGURATION_BUILDER_BUILD = MethodMatchers.create().ofSubTypes(new String[]{"io.realm.RealmConfiguration$Builder"}).names(new String[]{"build"}).addWithoutParametersMatcher().build();
    private static final MethodMatchers REALM_CONFIGURATION_BUILDER_ENCRYPTION_KEY = MethodMatchers.create().ofSubTypes(new String[]{"io.realm.RealmConfiguration$Builder"}).names(new String[]{"encryptionKey"}).withAnyParameters().build();
    private static final MethodMatchers REALM_CONFIGURATION_BUILDER_BUILDER = MethodMatchers.create().ofSubTypes(new String[]{"io.realm.RealmConfiguration$Builder"}).constructor().withAnyParameters().build();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        MethodInvocationTree mit = (MethodInvocationTree)tree;
        if (UNSAFE_DATABASE_CALL.matches(mit) || REALM_CONFIGURATION_BUILDER_BUILD.matches(mit) && !AndroidUnencryptedDatabaseCheck.isEncrypted(mit.methodSelect())) {
            this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), "Make sure using an unencrypted database is safe here.");
        }
    }

    private static boolean isEncrypted(ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            expression = ((MemberSelectExpressionTree)expression).expression();
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)expression;
            if (!REALM_CONFIGURATION_BUILDER_ENCRYPTION_KEY.matches(mit)) {
                return AndroidUnencryptedDatabaseCheck.isEncrypted(mit.methodSelect());
            }
        } else {
            NewClassTree newClassTree;
            if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                Symbol symbol = ((IdentifierTree)expression).symbol();
                if (symbol.usages().stream().anyMatch(AndroidUnencryptedDatabaseCheck::canEncryptToken)) {
                    return true;
                }
                return AndroidUnencryptedDatabaseCheck.declarationIsEncrypted(symbol);
            }
            if (expression.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) && REALM_CONFIGURATION_BUILDER_BUILDER.matches(newClassTree = (NewClassTree)expression)) {
                return false;
            }
        }
        return true;
    }

    private static boolean canEncryptToken(IdentifierTree tokenIdentifier) {
        Tree parent = tokenIdentifier.parent();
        return parent != null && parent.is(new Tree.Kind[]{Tree.Kind.ARGUMENTS}) || MethodTreeUtils.subsequentMethodInvocation((Tree)tokenIdentifier, REALM_CONFIGURATION_BUILDER_ENCRYPTION_KEY).isPresent();
    }

    private static boolean declarationIsEncrypted(Symbol symbol) {
        Tree declaration;
        if (symbol.isLocalVariable() && (declaration = symbol.declaration()) instanceof VariableTree) {
            ExpressionTree initializer = ((VariableTree)declaration).initializer();
            return initializer instanceof MethodInvocationTree && AndroidUnencryptedDatabaseCheck.isEncrypted(initializer);
        }
        return true;
    }
}

