/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.serialization;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.serialization.SerializableContract;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WildcardTree;

@Rule(key="S1948")
public class SerializableFieldInSerializableClassCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVAX_INJECT = "javax.inject.Inject";
    private static final String[] EXCLUDED_ANNOTATIONS = new String[]{"jakarta.annotation.Resource", "javax.annotation.Resource", "javax.ejb.EJB", "javax.inject.Inject", "org.apache.wicket.spring.injection.annot.SpringBean"};

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (SerializableFieldInSerializableClassCheck.isSerializable((Tree)classTree) && !SerializableContract.hasSpecialHandlingSerializationMethods(classTree) && !classTree.symbol().type().isSubtypeOf("javax.servlet.http.HttpServlet")) {
            Set<String> constructorInjectedParams = SerializableFieldInSerializableClassCheck.getConstructorOrMethodInjectedFields(classTree);
            classTree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})).map(VariableTree.class::cast).filter(variableTree -> !SerializableFieldInSerializableClassCheck.isExcluded(variableTree) && !constructorInjectedParams.contains(variableTree.simpleName().name())).forEach(this::checkVariableMember);
        }
    }

    private static Set<String> getConstructorOrMethodInjectedFields(ClassTree classTree) {
        AssignmentsVisitor assignmentsVisitor = new AssignmentsVisitor();
        classTree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR, Tree.Kind.METHOD})).map(MethodTree.class::cast).filter(methodTree -> SerializableFieldInSerializableClassCheck.isAnnotatedWith(methodTree.symbol().metadata(), JAVAX_INJECT)).forEach(methodTree -> methodTree.accept((TreeVisitor)assignmentsVisitor));
        return assignmentsVisitor.getAssignedVariables();
    }

    private void checkVariableMember(VariableTree variableTree) {
        IdentifierTree simpleName = variableTree.simpleName();
        if (SerializableFieldInSerializableClassCheck.isCollectionOfSerializable((Tree)variableTree.type())) {
            if (!ModifiersUtils.hasModifier((ModifiersTree)variableTree.modifiers(), (Modifier)Modifier.PRIVATE) && !SerializableFieldInSerializableClassCheck.implementsSerializable(variableTree.type().symbolType())) {
                this.reportIssue((Tree)simpleName, "Make \"" + simpleName.name() + "\" private or transient.");
            } else if (SerializableFieldInSerializableClassCheck.isUnserializableCollection(variableTree.type().symbolType()) || SerializableFieldInSerializableClassCheck.isUnserializableCollection(variableTree.initializer())) {
                this.reportIssue(simpleName);
            }
            this.checkCollectionAssignments(variableTree.symbol().usages());
        } else {
            ExpressionTree initializer = variableTree.initializer();
            Symbol.VariableSymbol variableSymbol = (Symbol.VariableSymbol)variableTree.symbol();
            if (initializer == null || !variableSymbol.isFinal() || !SerializableFieldInSerializableClassCheck.implementsSerializable(initializer.symbolType())) {
                this.reportIssue(simpleName);
            }
        }
    }

    private static boolean isUnserializableCollection(@Nullable ExpressionTree expression) {
        return expression != null && !expression.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL}) && SerializableFieldInSerializableClassCheck.isUnserializableCollection(expression.symbolType());
    }

    private static boolean isUnserializableCollection(Type type) {
        return !type.symbol().isInterface() && SerializableFieldInSerializableClassCheck.isSubtypeOfCollectionApi(type) && !SerializableFieldInSerializableClassCheck.implementsSerializable(type);
    }

    private void checkCollectionAssignments(List<IdentifierTree> usages) {
        for (IdentifierTree usage : usages) {
            AssignmentExpressionTree assignment;
            Tree parentTree = usage.parent();
            if (!parentTree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) || !usage.equals((Object)(assignment = (AssignmentExpressionTree)parentTree).variable()) || !SerializableFieldInSerializableClassCheck.isUnserializableCollection(assignment.expression())) continue;
            this.reportIssue(usage);
        }
    }

    private void reportIssue(IdentifierTree tree) {
        this.reportIssue((Tree)tree, "Make \"" + tree.name() + "\" transient or serializable.");
    }

    private static boolean isExcluded(VariableTree variableTree) {
        return SerializableFieldInSerializableClassCheck.isStatic(variableTree) || SerializableFieldInSerializableClassCheck.isTransientSerializableOrInjected(variableTree);
    }

    private static boolean isCollectionOfSerializable(Tree tree) {
        ParameterizedTypeTree typeTree;
        if (tree.is(new Tree.Kind[]{Tree.Kind.PARAMETERIZED_TYPE}) && SerializableFieldInSerializableClassCheck.isSubtypeOfCollectionApi((typeTree = (ParameterizedTypeTree)tree).symbolType())) {
            return typeTree.typeArguments().stream().allMatch(SerializableFieldInSerializableClassCheck::isCollectionOfSerializable);
        }
        return SerializableFieldInSerializableClassCheck.isSerializable(tree);
    }

    private static boolean isSubtypeOfCollectionApi(Type type) {
        return type.isSubtypeOf("java.util.Collection") || type.isSubtypeOf("java.util.Map");
    }

    private static boolean isStatic(VariableTree member) {
        return ModifiersUtils.hasModifier((ModifiersTree)member.modifiers(), (Modifier)Modifier.STATIC);
    }

    private static boolean isTransientSerializableOrInjected(VariableTree member) {
        if (ModifiersUtils.hasModifier((ModifiersTree)member.modifiers(), (Modifier)Modifier.TRANSIENT) || SerializableFieldInSerializableClassCheck.isSerializable((Tree)member.type()) && !SerializableFieldInSerializableClassCheck.isSubtypeOfCollectionApi(member.type().symbolType())) {
            return true;
        }
        SymbolMetadata metadata = member.symbol().metadata();
        return SerializableFieldInSerializableClassCheck.isAnnotatedWith(metadata, EXCLUDED_ANNOTATIONS);
    }

    private static boolean isAnnotatedWith(SymbolMetadata metadata, String ... fullyQualifiedNames) {
        HashSet<String> fullyQualifiedNamesSet = new HashSet<String>(Arrays.asList(fullyQualifiedNames));
        return metadata.annotations().stream().map(a -> a.symbol().type()).anyMatch(t -> t.isUnknown() || fullyQualifiedNamesSet.contains(t.fullyQualifiedName()));
    }

    private static boolean isSerializable(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.ENUM, Tree.Kind.PRIMITIVE_TYPE})) {
            return true;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS})) {
            Symbol.TypeSymbol symbol = ((ClassTree)tree).symbol();
            return SerializableFieldInSerializableClassCheck.implementsSerializable(symbol.type());
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.EXTENDS_WILDCARD, Tree.Kind.SUPER_WILDCARD, Tree.Kind.UNBOUNDED_WILDCARD})) {
            TypeTree bound = ((WildcardTree)tree).bound();
            return bound != null && SerializableFieldInSerializableClassCheck.implementsSerializable(bound.symbolType());
        }
        return SerializableFieldInSerializableClassCheck.implementsSerializable(((TypeTree)tree).symbolType());
    }

    private static boolean implementsSerializable(@Nullable Type type) {
        if (type == null || type.isUnknown() || type.isPrimitive()) {
            return true;
        }
        if (type.isArray()) {
            return SerializableFieldInSerializableClassCheck.implementsSerializable(((Type.ArrayType)type).elementType());
        }
        if (type.isClass() || type.isTypeVar()) {
            return type.isSubtypeOf("java.io.Serializable");
        }
        return false;
    }

    private static final class AssignmentsVisitor
    extends BaseTreeVisitor {
        private final Set<String> assignedVariables = new HashSet<String>();

        private AssignmentsVisitor() {
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            if (ExpressionUtils.isSelectOnThisOrSuper((AssignmentExpressionTree)tree)) {
                MemberSelectExpressionTree select = (MemberSelectExpressionTree)tree.variable();
                this.assignedVariables.add(select.identifier().name());
            } else if (tree.variable().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                IdentifierTree identifier = (IdentifierTree)tree.variable();
                this.assignedVariables.add(identifier.name());
            }
        }

        public Set<String> getAssignedVariables() {
            return Collections.unmodifiableSet(this.assignedVariables);
        }
    }
}

