/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.List;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6814")
public class OptionalRestParametersShouldBeObjectsCheck
extends IssuableSubscriptionVisitor {
    private static final String PATH_VARIABLE_ANNOTATION = "org.springframework.web.bind.annotation.PathVariable";
    private static final String REQUEST_PARAM_ANNOTATION = "org.springframework.web.bind.annotation.RequestParam";
    private static final List<String> PARAMETER_ANNOTATIONS = List.of("org.springframework.web.bind.annotation.PathVariable", "org.springframework.web.bind.annotation.RequestParam");

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree method = (MethodTree)tree;
        method.parameters().stream().filter(OptionalRestParametersShouldBeObjectsCheck::isOptionalPrimitive).forEach(parameter -> this.reportIssue((Tree)parameter, "Convert this optional parameter to an Object type."));
    }

    private static boolean isOptionalPrimitive(VariableTree parameter) {
        return parameter.type().symbolType().isPrimitive() && parameter.modifiers().annotations().stream().anyMatch(annotation -> OptionalRestParametersShouldBeObjectsCheck.isMarkingAsOptional(annotation) && !OptionalRestParametersShouldBeObjectsCheck.hasDefaultValue(annotation));
    }

    private static boolean isMarkingAsOptional(AnnotationTree annotation) {
        return PARAMETER_ANNOTATIONS.stream().anyMatch(candidate -> annotation.annotationType().symbolType().is(candidate)) && OptionalRestParametersShouldBeObjectsCheck.streamAllNamedArguments(annotation).anyMatch(assignment -> {
            IdentifierTree variable = (IdentifierTree)assignment.variable();
            Boolean constant = assignment.expression().asConstant(Boolean.class).orElse(Boolean.TRUE);
            return "required".equals(variable.name()) && Boolean.FALSE.equals(constant);
        });
    }

    private static boolean hasDefaultValue(AnnotationTree annotation) {
        return annotation.annotationType().symbolType().is(REQUEST_PARAM_ANNOTATION) && OptionalRestParametersShouldBeObjectsCheck.streamAllNamedArguments(annotation).anyMatch(assignment -> {
            IdentifierTree variable = (IdentifierTree)assignment.variable();
            return "defaultValue".equals(variable.name());
        });
    }

    private static Stream<AssignmentExpressionTree> streamAllNamedArguments(AnnotationTree annotation) {
        return annotation.arguments().stream().filter(expression -> expression.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})).map(AssignmentExpressionTree.class::cast);
    }
}

