/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.check.Rule;
import org.sonar.java.model.DefaultJavaFileScannerContext;
import org.sonar.java.model.DefaultModuleScannerContext;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.plugins.java.api.InputFileScannerContext;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.ModuleScannerContext;
import org.sonar.plugins.java.api.internal.EndOfAnalysis;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.collections.SetUtils;

@Rule(key="S4605")
public class SpringBeansShouldBeAccessibleCheck
extends IssuableSubscriptionVisitor
implements EndOfAnalysis {
    private static final Logger LOG = LoggerFactory.getLogger(SpringBeansShouldBeAccessibleCheck.class);
    private static final String MESSAGE_FORMAT = "'%s' is not reachable by @ComponentScan or @SpringBootApplication. Either move it to a package configured in @ComponentScan or update your @ComponentScan configuration.";
    private static final String[] SPRING_BEAN_ANNOTATIONS = new String[]{"org.springframework.stereotype.Component", "org.springframework.stereotype.Service", "org.springframework.stereotype.Repository", "org.springframework.stereotype.Controller", "org.springframework.web.bind.annotation.RestController"};
    private static final String COMPONENT_SCAN_ANNOTATION = "org.springframework.context.annotation.ComponentScan";
    private static final Set<String> COMPONENT_SCAN_ARGUMENTS = SetUtils.immutableSetOf((Object[])new String[]{"basePackages", "value"});
    private static final String SPRING_BOOT_APP_ANNOTATION = "org.springframework.boot.autoconfigure.SpringBootApplication";
    private static final String CACHE_KEY_PREFIX = "java:S4605:targeted:";
    private final Map<String, List<AnalyzerMessage>> messagesPerPackage = new HashMap<String, List<AnalyzerMessage>>();
    private final Set<String> packagesScannedBySpringAtProjectLevel = new HashSet<String>();
    private final Set<String> packagesScannedBySpringAtFileLevel = new HashSet<String>();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public boolean scanWithoutParsing(InputFileScannerContext inputFileScannerContext) {
        return SpringBeansShouldBeAccessibleCheck.readFromCache(inputFileScannerContext).map(targetedPackages -> {
            this.packagesScannedBySpringAtProjectLevel.addAll((Collection<String>)targetedPackages);
            return true;
        }).orElse(false);
    }

    public void endOfAnalysis(ModuleScannerContext context) {
        DefaultModuleScannerContext defaultContext = (DefaultModuleScannerContext)context;
        this.messagesPerPackage.entrySet().stream().filter(entry -> this.packagesScannedBySpringAtProjectLevel.stream().noneMatch(((String)entry.getKey())::contains)).forEach(entry -> ((List)entry.getValue()).forEach(arg_0 -> ((DefaultModuleScannerContext)defaultContext).reportIssue(arg_0)));
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (classTree.simpleName() == null) {
            return;
        }
        String classPackageName = SpringBeansShouldBeAccessibleCheck.packageNameOf((Symbol)classTree.symbol());
        SymbolMetadata classSymbolMetadata = classTree.symbol().metadata();
        List componentScanValues = classSymbolMetadata.valuesForAnnotation(COMPONENT_SCAN_ANNOTATION);
        if (componentScanValues != null) {
            componentScanValues.forEach(this::addToScannedPackages);
        } else if (SpringBeansShouldBeAccessibleCheck.hasAnnotation(classSymbolMetadata, SPRING_BOOT_APP_ANNOTATION)) {
            List<String> targetedPackages = SpringBeansShouldBeAccessibleCheck.targetedPackages(classPackageName, classSymbolMetadata);
            this.packagesScannedBySpringAtProjectLevel.addAll(targetedPackages);
            this.packagesScannedBySpringAtFileLevel.addAll(targetedPackages);
        } else if (SpringBeansShouldBeAccessibleCheck.hasAnnotation(classSymbolMetadata, SPRING_BEAN_ANNOTATIONS)) {
            this.addMessageToMap(classPackageName, classTree.simpleName());
        }
    }

    public void setContext(JavaFileScannerContext context) {
        this.packagesScannedBySpringAtFileLevel.clear();
        super.setContext(context);
    }

    public void leaveFile(JavaFileScannerContext context) {
        super.leaveFile(context);
        if (context.getCacheContext().isCacheEnabled()) {
            SpringBeansShouldBeAccessibleCheck.writeToCache((InputFileScannerContext)context, this.packagesScannedBySpringAtFileLevel);
        }
        this.packagesScannedBySpringAtFileLevel.clear();
    }

    private static String cacheKey(InputFile inputFile) {
        return CACHE_KEY_PREFIX + inputFile.key();
    }

    private static void writeToCache(InputFileScannerContext context, Collection<String> targetedPackages) {
        String cacheKey = SpringBeansShouldBeAccessibleCheck.cacheKey(context.getInputFile());
        byte[] data = String.join((CharSequence)";", targetedPackages).getBytes(StandardCharsets.UTF_8);
        try {
            context.getCacheContext().getWriteCache().write(cacheKey, data);
        }
        catch (IllegalArgumentException e) {
            LOG.trace("Tried to write multiple times to cache key '{}'. Ignoring writes after the first.", (Object)cacheKey);
        }
    }

    private static Optional<List<String>> readFromCache(InputFileScannerContext context) {
        String cacheKey = SpringBeansShouldBeAccessibleCheck.cacheKey(context.getInputFile());
        byte[] bytes = context.getCacheContext().getReadCache().readBytes(cacheKey);
        if (bytes != null) {
            context.getCacheContext().getWriteCache().copyFromPrevious(cacheKey);
            return Optional.of(Arrays.asList(new String(bytes, StandardCharsets.UTF_8).split(";")));
        }
        return Optional.empty();
    }

    private static List<String> targetedPackages(String classPackageName, SymbolMetadata classSymbolMetadata) {
        return Objects.requireNonNull(classSymbolMetadata.valuesForAnnotation(SPRING_BOOT_APP_ANNOTATION)).stream().filter(v -> "scanBasePackages".equals(v.name())).map(SymbolMetadata.AnnotationValue::value).findFirst().filter(Object[].class::isInstance).map(Object[].class::cast).map(SpringBeansShouldBeAccessibleCheck::asStringList).orElse(Collections.singletonList(classPackageName));
    }

    private static List<String> asStringList(Object[] array) {
        return Arrays.asList(array).stream().filter(String.class::isInstance).map(String.class::cast).collect(Collectors.toList());
    }

    private void addMessageToMap(String classPackageName, IdentifierTree classNameTree) {
        DefaultJavaFileScannerContext defaultContext = (DefaultJavaFileScannerContext)this.context;
        AnalyzerMessage analyzerMessage = defaultContext.createAnalyzerMessage((JavaCheck)this, (Tree)classNameTree, String.format(MESSAGE_FORMAT, classNameTree.name()));
        this.messagesPerPackage.computeIfAbsent(classPackageName, k -> new ArrayList()).add(analyzerMessage);
    }

    private void addToScannedPackages(SymbolMetadata.AnnotationValue annotationValue) {
        if (!COMPONENT_SCAN_ARGUMENTS.contains(annotationValue.name())) {
            return;
        }
        if (annotationValue.value() instanceof Object[]) {
            for (Object o : (Object[])annotationValue.value()) {
                if (!(o instanceof String)) continue;
                this.packagesScannedBySpringAtProjectLevel.add((String)o);
            }
        }
    }

    private static String packageNameOf(Symbol symbol) {
        Symbol owner = symbol.owner();
        while (!owner.isPackageSymbol()) {
            owner = owner.owner();
        }
        return owner.name();
    }

    private static boolean hasAnnotation(SymbolMetadata classSymbolMetadata, String ... annotationName) {
        return Arrays.stream(annotationName).anyMatch(arg_0 -> ((SymbolMetadata)classSymbolMetadata).isAnnotatedWith(arg_0));
    }
}

