/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4502")
public class SpringSecurityDisableCSRFCheck
extends AbstractMethodDetection {
    private static final String CSRF_CONFIGURER_CLASS = "org.springframework.security.config.annotation.web.configurers.CsrfConfigurer";
    private static final String MESSAGE = "Make sure disabling Spring Security's CSRF protection is safe here.";
    private static final MethodMatchers DISABLE_MATCHER = MethodMatchers.create().ofSubTypes(new String[]{"org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer"}).names(new String[]{"disable"}).addWithoutParametersMatcher().build();
    private static final MethodMatchers IGNORE_ANT_MATCHER = MethodMatchers.create().ofSubTypes(new String[]{"org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer"}).names(new String[]{"ignoringAntMatchers"}).addParametersMatcher(new String[]{"java.lang.String[]"}).build();

    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{DISABLE_MATCHER, IGNORE_ANT_MATCHER});
    }

    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        MemberSelectExpressionTree selectExpression;
        if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && (selectExpression = (MemberSelectExpressionTree)mit.methodSelect()).expression().symbolType().is(CSRF_CONFIGURER_CLASS)) {
            this.reportIssue((Tree)selectExpression.identifier(), MESSAGE);
        }
    }
}

