/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S5831")
public class AssertJApplyConfigurationCheck
extends AbstractMethodDetection {
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(new String[]{"org.assertj.core.configuration.Configuration"}).constructor().addWithoutParametersMatcher().build();
    }

    protected void onConstructorFound(NewClassTree newClassTree) {
        VariableTree variableTree;
        Tree parent = newClassTree.parent();
        if (parent != null && parent.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && (variableTree = (VariableTree)parent).symbol().usages().stream().noneMatch(AssertJApplyConfigurationCheck::canApplyConfiguration)) {
            this.reportIssue((Tree)variableTree.simpleName(), "Apply this configuration with apply() or applyAndDisplay().");
        }
    }

    private static boolean canApplyConfiguration(IdentifierTree identifier) {
        Tree parent = identifier.parent();
        if (parent == null) {
            return false;
        }
        if (parent.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            String methodName = ((MemberSelectExpressionTree)parent).identifier().name();
            return "apply".equals(methodName) || "applyAndDisplay".equals(methodName);
        }
        return parent.is(new Tree.Kind[]{Tree.Kind.ARGUMENTS});
    }
}

