/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Objects;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2925")
public class ThreadSleepInTestsCheck
extends AbstractMethodDetection {
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        String name = Objects.requireNonNull(mit.methodSymbol().owner()).type().name();
        this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), String.format("Remove this use of \"%s.sleep()\".", name));
    }

    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.lang.Thread"}).names(new String[]{"sleep"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.util.concurrent.TimeUnit"}).names(new String[]{"sleep"}).withAnyParameters().build()});
    }
}

