/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.filters;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.java.checks.AtLeastOneConstructorCheck;
import org.sonar.java.checks.CollectionInappropriateCallsCheck;
import org.sonar.java.checks.ConstantsShouldBeStaticFinalCheck;
import org.sonar.java.checks.EqualsNotOverriddenInSubclassCheck;
import org.sonar.java.checks.EqualsNotOverridenWithCompareToCheck;
import org.sonar.java.checks.ExceptionsShouldBeImmutableCheck;
import org.sonar.java.checks.FieldModifierCheck;
import org.sonar.java.checks.PrivateFieldUsedLocallyCheck;
import org.sonar.java.checks.RegexPatternsNeedlesslyCheck;
import org.sonar.java.checks.SillyEqualsCheck;
import org.sonar.java.checks.StaticMethodCheck;
import org.sonar.java.checks.UselessImportCheck;
import org.sonar.java.checks.UtilityClassWithPublicConstructorCheck;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.naming.BadFieldNameCheck;
import org.sonar.java.checks.spring.SpringComponentWithNonAutowiredMembersCheck;
import org.sonar.java.checks.tests.AssertionTypesCheck;
import org.sonar.java.checks.unused.UnusedPrivateFieldCheck;
import org.sonar.java.filters.BaseTreeVisitorIssueFilter;
import org.sonar.java.se.checks.XxeProcessingCheck;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class LombokFilter
extends BaseTreeVisitorIssueFilter {
    private static final Set<Class<? extends JavaCheck>> FILTERED_RULES = Set.of(AssertionTypesCheck.class, AtLeastOneConstructorCheck.class, BadFieldNameCheck.class, CollectionInappropriateCallsCheck.class, ConstantsShouldBeStaticFinalCheck.class, EqualsNotOverriddenInSubclassCheck.class, EqualsNotOverridenWithCompareToCheck.class, ExceptionsShouldBeImmutableCheck.class, FieldModifierCheck.class, PrivateFieldUsedLocallyCheck.class, RegexPatternsNeedlesslyCheck.class, SillyEqualsCheck.class, SpringComponentWithNonAutowiredMembersCheck.class, StaticMethodCheck.class, UnusedPrivateFieldCheck.class, UselessImportCheck.class, UtilityClassWithPublicConstructorCheck.class, XxeProcessingCheck.class);
    private static final String LOMBOK_BUILDER = "lombok.Builder";
    private static final String LOMBOK_SUPER_BUILDER = "lombok.SuperBuilder";
    private static final String LOMBOK_BUILDER_DEFAULT = "lombok.Builder$Default";
    private static final String LOMBOK_VAL = "lombok.val";
    private static final String LOMBOK_VALUE = "lombok.Value";
    private static final String LOMBOK_FIELD_DEFAULTS = "lombok.experimental.FieldDefaults";
    private static final String LOMBOK_DATA = "lombok.Data";
    private static final List<String> GENERATE_UNUSED_FIELD_RELATED_METHODS = List.of("lombok.Getter", "lombok.Setter", "lombok.Builder", "lombok.SuperBuilder", "lombok.ToString", "lombok.AllArgsConstructor", "lombok.NoArgsConstructor", "lombok.RequiredArgsConstructor");
    private static final List<String> GENERATE_CONSTRUCTOR = List.of("lombok.AllArgsConstructor", "lombok.NoArgsConstructor", "lombok.RequiredArgsConstructor", "lombok.Data");
    private static final List<String> GENERATE_EQUALS = List.of("lombok.EqualsAndHashCode", "lombok.Data", "lombok.Value");
    private static final List<String> UTILITY_CLASS = Collections.singletonList("lombok.experimental.UtilityClass");
    private static final List<String> NON_FINAL = Collections.singletonList("lombok.experimental.NonFinal");

    @Override
    public Set<Class<? extends JavaCheck>> filteredRules() {
        return FILTERED_RULES;
    }

    public void visitImport(ImportTree tree) {
        String fullyQualifiedName = ExpressionsHelper.concatenate((ExpressionTree)((ExpressionTree)tree.qualifiedIdentifier()));
        this.excludeLinesIfTrue("lombok.var".equals(fullyQualifiedName) || LOMBOK_VAL.equals(fullyQualifiedName), (Tree)tree, (Class<? extends JavaCheck>)UselessImportCheck.class);
        super.visitImport(tree);
    }

    public void visitClass(ClassTree tree) {
        boolean generatesEquals = LombokFilter.usesAnnotation(tree, GENERATE_EQUALS);
        this.excludeLinesIfTrue(generatesEquals || LombokFilter.usesAnnotation(tree, GENERATE_UNUSED_FIELD_RELATED_METHODS), (Tree)tree, UnusedPrivateFieldCheck.class, PrivateFieldUsedLocallyCheck.class);
        this.excludeLinesIfTrue(LombokFilter.usesAnnotation(tree, GENERATE_CONSTRUCTOR), (Tree)tree, AtLeastOneConstructorCheck.class, SpringComponentWithNonAutowiredMembersCheck.class);
        this.excludeLinesIfTrue(generatesEquals, (Tree)tree, EqualsNotOverriddenInSubclassCheck.class, EqualsNotOverridenWithCompareToCheck.class);
        this.excludeLinesIfTrue(LombokFilter.generatesNonPublicConstructor(tree), (Tree)tree, (Class<? extends JavaCheck>)UtilityClassWithPublicConstructorCheck.class);
        boolean isUtilityClass = LombokFilter.usesAnnotation(tree, UTILITY_CLASS);
        this.excludeLinesIfTrue(isUtilityClass, (Tree)tree, BadFieldNameCheck.class, ConstantsShouldBeStaticFinalCheck.class, StaticMethodCheck.class);
        if (isUtilityClass) {
            tree.members().stream().filter(t -> t.is(new Tree.Kind[]{Tree.Kind.VARIABLE})).forEach(v -> this.excludeLines((Tree)v, (Class<? extends JavaCheck>)RegexPatternsNeedlesslyCheck.class));
        }
        if (LombokFilter.generatesPrivateFields(tree)) {
            tree.members().stream().filter(t -> t.is(new Tree.Kind[]{Tree.Kind.VARIABLE})).map(VariableTree.class::cast).filter(v -> !LombokFilter.generatesPackagePrivateAccess(v)).forEach(v -> this.excludeLines((Tree)v, (Class<? extends JavaCheck>)FieldModifierCheck.class));
        }
        if (LombokFilter.generatesFinalFields(tree)) {
            tree.members().stream().filter(t -> t.is(new Tree.Kind[]{Tree.Kind.VARIABLE})).map(VariableTree.class::cast).filter(v -> !LombokFilter.generatesNonFinal(v)).forEach(v -> this.excludeLines((Tree)v, (Class<? extends JavaCheck>)ExceptionsShouldBeImmutableCheck.class));
        }
        if (LombokFilter.usesAnnotation(tree, List.of(LOMBOK_BUILDER, LOMBOK_SUPER_BUILDER))) {
            tree.members().stream().filter(t -> t.is(new Tree.Kind[]{Tree.Kind.VARIABLE})).map(VariableTree.class::cast).filter(v -> v.symbol().isFinal() && v.symbol().metadata().isAnnotatedWith(LOMBOK_BUILDER_DEFAULT)).forEach(v -> this.excludeLines((Tree)v, (Class<? extends JavaCheck>)ConstantsShouldBeStaticFinalCheck.class));
        }
        super.visitClass(tree);
    }

    public void visitVariable(VariableTree tree) {
        this.excludeLinesIfTrue(tree.symbol().type().is(LOMBOK_VAL) && tree.initializer() != null, (Tree)tree.initializer(), (Class<? extends JavaCheck>)XxeProcessingCheck.class);
        super.visitVariable(tree);
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        this.excludeLinesIfTrue(tree.variable().symbolType().is(LOMBOK_VAL), (Tree)tree.expression(), (Class<? extends JavaCheck>)XxeProcessingCheck.class);
        super.visitAssignmentExpression(tree);
    }

    private static boolean usesAnnotation(ClassTree classTree, List<String> annotations) {
        SymbolMetadata classMetadata = classTree.symbol().metadata();
        return annotations.stream().anyMatch(arg_0 -> ((SymbolMetadata)classMetadata).isAnnotatedWith(arg_0));
    }

    private static boolean generatesNonPublicConstructor(ClassTree classTree) {
        if (LombokFilter.usesAnnotation(classTree, UTILITY_CLASS)) {
            return true;
        }
        SymbolMetadata metadata = classTree.symbol().metadata();
        return GENERATE_CONSTRUCTOR.stream().map(arg_0 -> ((SymbolMetadata)metadata).valuesForAnnotation(arg_0)).filter(Objects::nonNull).anyMatch(LombokFilter::generatesNonPublicAccess);
    }

    private static boolean generatesNonPublicAccess(List<SymbolMetadata.AnnotationValue> values) {
        return values.stream().anyMatch(av -> "access".equals(av.name()) && !"PUBLIC".equals(LombokFilter.getAccessLevelValue(av.value())));
    }

    private static boolean generatesPrivateFields(ClassTree tree) {
        if (LombokFilter.usesAnnotation(tree, Collections.singletonList(LOMBOK_VALUE))) {
            return true;
        }
        List annotationValues = tree.symbol().metadata().valuesForAnnotation(LOMBOK_FIELD_DEFAULTS);
        return annotationValues != null && annotationValues.stream().filter(Objects::nonNull).anyMatch(av -> "level".equals(av.name()) && "PRIVATE".equals(LombokFilter.getAccessLevelValue(av.value())));
    }

    private static boolean generatesPackagePrivateAccess(VariableTree tree) {
        return tree.symbol().metadata().isAnnotatedWith("lombok.experimental.PackagePrivate");
    }

    private static boolean generatesFinalFields(ClassTree classTree) {
        if (LombokFilter.usesAnnotation(classTree, Collections.singletonList(LOMBOK_VALUE)) && !LombokFilter.usesAnnotation(classTree, NON_FINAL)) {
            return true;
        }
        List annotationValues = classTree.symbol().metadata().valuesForAnnotation(LOMBOK_FIELD_DEFAULTS);
        return annotationValues != null && annotationValues.stream().filter(Objects::nonNull).anyMatch(av -> "makeFinal".equals(av.name()) && LombokFilter.getMakeFinalValue(av.value()));
    }

    private static boolean generatesNonFinal(VariableTree tree) {
        return tree.symbol().metadata().isAnnotatedWith("lombok.experimental.NonFinal");
    }

    @Nullable
    private static String getAccessLevelValue(Object value) {
        if (value instanceof Symbol) {
            return ((Symbol)value).name();
        }
        return null;
    }

    private static boolean getMakeFinalValue(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public void visitIdentifier(IdentifierTree tree) {
        Symbol symbol = tree.symbol();
        if (symbol.isVariableSymbol() && symbol.type().is(LOMBOK_VAL)) {
            LombokFilter.parentMethodInvocation(tree).ifPresent(mit -> this.excludeLines((Tree)mit, (Class<? extends JavaCheck>)SillyEqualsCheck.class, (Class<? extends JavaCheck>)CollectionInappropriateCallsCheck.class, (Class<? extends JavaCheck>)AssertionTypesCheck.class));
        }
        super.visitIdentifier(tree);
    }

    private static Optional<Tree> parentMethodInvocation(IdentifierTree identifier) {
        Tree parent;
        for (parent = identifier.parent(); parent != null && !parent.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}); parent = parent.parent()) {
        }
        return Optional.ofNullable(parent);
    }
}

