/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.collections.MapBuilder;
import org.sonarsource.analyzer.commons.collections.SetUtils;

@Rule(key="S1319")
public class CollectionImplementationReferencedCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String LIST = "java.util.List";
    private static final String DEQUE = "java.util.Deque";
    private static final String QUEUE = "java.util.Queue";
    private static final String SET = "java.util.Set";
    private static final String SORTED_SET = "java.util.SortedSet";
    private static final String MAP = "java.util.Map";
    private static final String CONCURRENT_MAP = "java.util.concurrent.ConcurrentMap";
    private static final String SORTED_MAP = "java.util.SortedMap";
    private static final Map<String, String> SUGGESTED_INTERFACE_BY_COLLECTION_CLASS = MapBuilder.newMap().put((Object)"java.util.ArrayDeque", (Object)"java.util.Deque").put((Object)"java.util.concurrent.ConcurrentLinkedDeque", (Object)"java.util.Deque").put((Object)"java.util.AbstractList", (Object)"java.util.List").put((Object)"java.util.AbstractSequentialList", (Object)"java.util.List").put((Object)"java.util.ArrayList", (Object)"java.util.List").put((Object)"java.util.LinkedList", (Object)"java.util.List").put((Object)"java.util.concurrent.CopyOnWriteArrayList", (Object)"java.util.List").put((Object)"java.util.AbstractMap", (Object)"java.util.Map").put((Object)"java.util.EnumMap", (Object)"java.util.Map").put((Object)"java.util.HashMap", (Object)"java.util.Map").put((Object)"java.util.Hashtable", (Object)"java.util.Map").put((Object)"java.util.IdentityHashMap", (Object)"java.util.Map").put((Object)"java.util.LinkedHashMap", (Object)"java.util.Map").put((Object)"java.util.WeakHashMap", (Object)"java.util.Map").put((Object)"java.util.concurrent.ConcurrentHashMap", (Object)"java.util.concurrent.ConcurrentMap").put((Object)"java.util.concurrent.ConcurrentSkipListMap", (Object)"java.util.concurrent.ConcurrentMap").put((Object)"java.util.AbstractQueue", (Object)"java.util.Queue").put((Object)"java.util.concurrent.ConcurrentLinkedQueue", (Object)"java.util.Queue").put((Object)"java.util.concurrent.SynchronousQueue", (Object)"java.util.Queue").put((Object)"java.util.AbstractSet", (Object)"java.util.Set").put((Object)"java.util.concurrent.CopyOnWriteArraySet", (Object)"java.util.Set").put((Object)"java.util.EnumSet", (Object)"java.util.Set").put((Object)"java.util.HashSet", (Object)"java.util.Set").put((Object)"java.util.LinkedHashSet", (Object)"java.util.Set").put((Object)"java.util.TreeMap", (Object)"java.util.SortedMap").put((Object)"java.util.TreeSet", (Object)"java.util.SortedSet").build();
    private static final Set<String> COLLECTION_METHODS = Set.of("add", "addAll", "clear", "contains", "containsAll", "equals", "forEach", "hashCode", "isEmpty", "iterator", "parallelStream", "remove", "removeAll", "removeIf", "retainAll", "size", "spliterator", "stream", "toArray");
    private static final Set<String> LIST_METHODS = SetUtils.concat((Set[])new Set[]{COLLECTION_METHODS, Set.of("copyOf", "get", "indexOf", "lastIndexOf", "listIterator", "replaceAll", "set", "sort", "subList")});
    private static final Set<String> QUEUE_METHODS = SetUtils.concat((Set[])new Set[]{COLLECTION_METHODS, Set.of("element", "offer", "peek", "poll")});
    private static final Set<String> DEQUE_METHODS = SetUtils.concat((Set[])new Set[]{QUEUE_METHODS, Set.of("addFirst", "addLast", "descendingIterator", "getFirst", "getLast", "offerFirst", "offerLast", "peekFirst", "peekLast", "pollFirst", "pollLast", "pop", "push", "removeFirst", "removeFirstOccurrence", "removeLast", "removeLastOccurrence")});
    private static final Set<String> SET_METHODS = SetUtils.concat((Set[])new Set[]{COLLECTION_METHODS, Set.of("copyOf")});
    private static final Set<String> SORTED_SET_METHODS = SetUtils.concat((Set[])new Set[]{SET_METHODS, Set.of("comparator", "first", "headSet", "last", "subSet", "tailSet")});
    private static final Set<String> MAP_METHODS = Set.of("clear", "compute", "computeIfAbsent", "computeIfPresent", "containsKey", "containsValue", "copyOf", "entry", "entrySet", "equals", "forEach", "get", "getOrDefault", "hashCode", "isEmpty", "keySet", "of", "ofEntries", "put", "putAll", "putIfAbsent", "remove", "replace", "replaceAll", "size", "values");
    private static final Set<String> CONCURRENT_MAP_METHODS = SetUtils.concat((Set[])new Set[]{MAP_METHODS, Set.of("merge")});
    private static final Set<String> SORTED_MAP_METHODS = SetUtils.concat((Set[])new Set[]{MAP_METHODS, Set.of("comparator", "firstKey", "headMap", "lastKey", "subMap", "tailMap")});
    private static final Map<String, Set<String>> METHODS_BY_INTERFACE = Map.of("java.util.List", LIST_METHODS, "java.util.Queue", QUEUE_METHODS, "java.util.Deque", DEQUE_METHODS, "java.util.Set", SET_METHODS, "java.util.SortedSet", SORTED_SET_METHODS, "java.util.Map", MAP_METHODS, "java.util.concurrent.ConcurrentMap", CONCURRENT_MAP_METHODS, "java.util.SortedMap", SORTED_MAP_METHODS);
    private JavaFileScannerContext context;
    private QuickFixHelper.ImportSupplier importSupplier;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.importSupplier = null;
        this.scan((Tree)context.getTree());
    }

    public void visitVariable(VariableTree tree) {
        super.visitVariable(tree);
        if (CollectionImplementationReferencedCheck.isPublic(tree.modifiers())) {
            this.checkIfAllowed(tree.type(), String.format("The type of \"%s\"", tree.simpleName()));
        }
    }

    public void visitMethod(MethodTree tree) {
        boolean isOverridingMethod;
        super.visitMethod(tree);
        boolean isNotPublic = !CollectionImplementationReferencedCheck.isPublic(tree.modifiers());
        boolean bl = isOverridingMethod = !Boolean.FALSE.equals(tree.isOverriding());
        if (isNotPublic || isOverridingMethod) {
            return;
        }
        this.checkIfAllowed(tree.returnType(), "The return type of this method");
        List<VariableTree> candidateParameters = tree.parameters().stream().filter(it -> CollectionImplementationReferencedCheck.getSuggestedInterface(it.type()) != null).collect(Collectors.toList());
        if (candidateParameters.isEmpty()) {
            return;
        }
        Stream<Object> reportParameters = candidateParameters.stream();
        BlockTree block = tree.block();
        if (block != null) {
            MethodBodyVisitor visitor = new MethodBodyVisitor(candidateParameters);
            block.accept((TreeVisitor)visitor);
            reportParameters = reportParameters.filter(it -> !visitor.excludedParameters.contains(it));
        }
        reportParameters.forEach(it -> this.report(it.type(), String.format("The type of \"%s\"", it.simpleName())));
    }

    private void checkIfAllowed(@Nullable TypeTree tree, String messagePrefix) {
        if (CollectionImplementationReferencedCheck.getSuggestedInterface(tree) != null) {
            this.report(tree, messagePrefix);
        }
    }

    @Nullable
    private static String getSuggestedInterface(@Nullable TypeTree tree) {
        if (tree == null) {
            return null;
        }
        String className = tree.symbolType().erasure().fullyQualifiedName();
        return SUGGESTED_INTERFACE_BY_COLLECTION_CLASS.get(className);
    }

    private void report(TypeTree tree, String messagePrefix) {
        TypeTree reportTree = tree.is(new Tree.Kind[]{Tree.Kind.PARAMETERIZED_TYPE}) ? ((ParameterizedTypeTree)tree).type() : tree;
        String className = tree.symbolType().erasure().fullyQualifiedName();
        String targetCollection = SUGGESTED_INTERFACE_BY_COLLECTION_CLASS.get(className);
        String usedCollectionSimpleName = CollectionImplementationReferencedCheck.toSimpleName(className);
        QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)reportTree).withMessage("%s should be an interface such as \"%s\" rather than the implementation \"%s\".", new Object[]{messagePrefix, CollectionImplementationReferencedCheck.toSimpleName(targetCollection), usedCollectionSimpleName}).withQuickFix(() -> this.quickFix(reportTree, usedCollectionSimpleName, targetCollection)).report();
    }

    private JavaQuickFix quickFix(TypeTree typeTree, String usedCollection, String targetedCollection) {
        String targetedCollectionSimpleName = CollectionImplementationReferencedCheck.toSimpleName(targetedCollection);
        ArrayList<JavaTextEdit> edits = new ArrayList<JavaTextEdit>();
        edits.add(JavaTextEdit.replaceTree((Tree)typeTree, (String)targetedCollectionSimpleName));
        this.getImportSupplier().newImportEdit(targetedCollection).ifPresent(edits::add);
        return JavaQuickFix.newQuickFix((String)"Replace \"%s\" by \"%s\"", (Object[])new Object[]{usedCollection, targetedCollectionSimpleName}).addTextEdits(edits).build();
    }

    private QuickFixHelper.ImportSupplier getImportSupplier() {
        if (this.importSupplier == null) {
            this.importSupplier = QuickFixHelper.newImportSupplier(this.context);
        }
        return this.importSupplier;
    }

    private static String toSimpleName(String fullyQualifiedName) {
        return fullyQualifiedName.substring(fullyQualifiedName.lastIndexOf(46) + 1);
    }

    private static boolean isPublic(ModifiersTree modifiers) {
        return ModifiersUtils.hasModifier((ModifiersTree)modifiers, (Modifier)Modifier.PUBLIC);
    }

    private static class MethodBodyVisitor
    extends BaseTreeVisitor {
        private final Map<String, VariableTree> candidateParametersByName = new HashMap<String, VariableTree>();
        public final Set<VariableTree> excludedParameters = new HashSet<VariableTree>();

        public MethodBodyVisitor(List<VariableTree> candidateParameters) {
            for (VariableTree variableTree : candidateParameters) {
                this.candidateParametersByName.put(variableTree.simpleName().name(), variableTree);
            }
        }

        public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
            super.visitMemberSelectExpression(tree);
            if (!(tree.expression() instanceof IdentifierTree)) {
                return;
            }
            String variableName = ((IdentifierTree)tree.expression()).name();
            VariableTree variableTree = this.candidateParametersByName.get(variableName);
            if (variableTree == null) {
                return;
            }
            String memberName = tree.identifier().name();
            String interfaceName = CollectionImplementationReferencedCheck.getSuggestedInterface(variableTree.type());
            if (!METHODS_BY_INTERFACE.get(interfaceName).contains(memberName)) {
                this.excludedParameters.add(variableTree);
            }
        }
    }
}

