/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6862")
public class ConfigurationBeanNamesCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (!ConfigurationBeanNamesCheck.isConfigurationClass(classTree)) {
            return;
        }
        List<MethodTree> beanMethods = ConfigurationBeanNamesCheck.getBeanMethods(classTree);
        HashSet<String> foundNames = new HashSet<String>();
        for (MethodTree beanMethod : beanMethods) {
            if (foundNames.add(beanMethod.simpleName().name())) continue;
            this.reportIssue((Tree)beanMethod.simpleName(), "Rename this bean method to prevent any conflict with other beans.");
        }
    }

    private static boolean isConfigurationClass(ClassTree classTree) {
        return classTree.symbol().metadata().isAnnotatedWith("org.springframework.context.annotation.Configuration");
    }

    private static List<MethodTree> getBeanMethods(ClassTree classTree) {
        return classTree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.METHOD})).map(MethodTree.class::cast).filter(method -> method.symbol().metadata().isAnnotatedWith("org.springframework.context.annotation.Bean")).collect(Collectors.toList());
    }
}

