/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S5917")
public class DateTimeFormatterMismatchCheck
extends IssuableSubscriptionVisitor {
    private static final String TEMPORAL_FIELD_TYPE = "java.time.temporal.TemporalField";
    private static final String INT_TYPE = "int";
    private static final MethodMatchers APPEND_VALUE_MATCHER = MethodMatchers.create().ofTypes(new String[]{"java.time.format.DateTimeFormatterBuilder"}).names(new String[]{"appendValue"}).addParametersMatcher(new String[]{"java.time.temporal.TemporalField"}).addParametersMatcher(new String[]{"java.time.temporal.TemporalField", "int"}).addParametersMatcher(new String[]{"java.time.temporal.TemporalField", "int", "int", "java.time.format.SignStyle"}).build();
    private static final String CHANGE_YEAR_FORMAT_WEEK_BASED_MESSAGE = "Change this year format to use the week-based year instead (or the week format to Chronofield.ALIGNED_WEEK_OF_YEAR).";
    private static final String CHANGE_YEAR_FORMAT_TO_CHRONOFIELD_MESSAGE = "Change this year format to use ChronoField.YEAR instead (or the week format to WeekFields.ISO.weekOfWeekBasedYear()).";
    private static final String SECONDARY_LOCATION_MESSAGE = "Week format is inconsistent with year.";
    private int depth = 0;

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        MethodInvocationTree invocation = (MethodInvocationTree)tree;
        if (APPEND_VALUE_MATCHER.matches(invocation)) {
            if (this.depth == 0) {
                ChainedInvocationVisitor visitor = new ChainedInvocationVisitor();
                invocation.accept((TreeVisitor)visitor);
                if (visitor.usesWeek && visitor.usesYear) {
                    if (visitor.usesWeekBasedYear && !visitor.usesWeekOfWeekBasedYear) {
                        this.reportIssue((Tree)visitor.primary, CHANGE_YEAR_FORMAT_TO_CHRONOFIELD_MESSAGE, visitor.secondaries, null);
                    } else if (!visitor.usesWeekBasedYear && visitor.usesWeekOfWeekBasedYear) {
                        this.reportIssue((Tree)visitor.primary, CHANGE_YEAR_FORMAT_WEEK_BASED_MESSAGE, visitor.secondaries, null);
                    }
                }
            }
            ++this.depth;
        }
    }

    public void leaveNode(Tree tree) {
        if (APPEND_VALUE_MATCHER.matches((MethodInvocationTree)tree)) {
            --this.depth;
        }
    }

    public void leaveFile(JavaFileScannerContext context) {
        this.depth = 0;
    }

    private static class ChainedInvocationVisitor
    extends BaseTreeVisitor {
        private static final MethodMatchers WEEK_BASED_YEAR_MATCHER = MethodMatchers.create().ofTypes(new String[]{"java.time.temporal.WeekFields"}).names(new String[]{"weekBasedYear"}).addWithoutParametersMatcher().build();
        private static final MethodMatchers WEEK_OF_WEEK_BASED_YEAR_MATCHER = MethodMatchers.create().ofTypes(new String[]{"java.time.temporal.WeekFields"}).names(new String[]{"weekOfWeekBasedYear"}).addWithoutParametersMatcher().build();
        private boolean usesWeek = false;
        private boolean usesWeekOfWeekBasedYear = false;
        private boolean usesYear = false;
        private boolean usesWeekBasedYear = false;
        private final List<JavaFileScannerContext.Location> secondaries = new ArrayList<JavaFileScannerContext.Location>();
        private ExpressionTree primary = null;

        private ChainedInvocationVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            this.inspectCall(tree);
            ExpressionTree expressionTree = tree.methodSelect();
            expressionTree.accept((TreeVisitor)this);
        }

        private void inspectCall(MethodInvocationTree invocation) {
            if (!APPEND_VALUE_MATCHER.matches(invocation)) {
                return;
            }
            ExpressionTree argument = (ExpressionTree)invocation.arguments().get(0);
            if (ChainedInvocationVisitor.refersToYear(argument)) {
                this.usesYear = true;
                if (this.primary == null) {
                    this.primary = argument;
                }
                boolean isWeekBasedYearArgument = ChainedInvocationVisitor.isWeekBasedYearUsed(argument);
                this.usesWeekBasedYear |= isWeekBasedYearArgument;
                if (isWeekBasedYearArgument) {
                    this.primary = argument;
                }
            } else if (ChainedInvocationVisitor.refersToWeek(argument)) {
                this.usesWeek = true;
                this.secondaries.add(new JavaFileScannerContext.Location(DateTimeFormatterMismatchCheck.SECONDARY_LOCATION_MESSAGE, (Tree)argument));
                this.usesWeekOfWeekBasedYear |= ChainedInvocationVisitor.isWeekOfWeekBasedYearUsed(argument);
            }
        }

        private static boolean refersToWeek(ExpressionTree argument) {
            return ChainedInvocationVisitor.isChronoFieldWeek(argument) || ChainedInvocationVisitor.isWeekOfWeekBasedYearUsed(argument);
        }

        private static boolean isWeekOfWeekBasedYearUsed(ExpressionTree argument) {
            if (argument.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                MethodInvocationTree call = (MethodInvocationTree)argument;
                return WEEK_OF_WEEK_BASED_YEAR_MATCHER.matches(call);
            }
            return false;
        }

        private static boolean isChronoFieldWeek(ExpressionTree argument) {
            if (!argument.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                return false;
            }
            MemberSelectExpressionTree select = (MemberSelectExpressionTree)argument;
            if (!select.symbolType().is("java.time.temporal.ChronoField")) {
                return false;
            }
            return "ALIGNED_WEEK_OF_YEAR".equals(select.identifier().name());
        }

        private static boolean refersToYear(ExpressionTree argument) {
            return ChainedInvocationVisitor.isChronoFieldYear(argument) || ChainedInvocationVisitor.isWeekBasedYearUsed(argument);
        }

        private static boolean isWeekBasedYearUsed(ExpressionTree argument) {
            if (argument.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                MethodInvocationTree call = (MethodInvocationTree)argument;
                return WEEK_BASED_YEAR_MATCHER.matches(call);
            }
            return false;
        }

        private static boolean isChronoFieldYear(ExpressionTree argument) {
            if (argument.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                MemberSelectExpressionTree select = (MemberSelectExpressionTree)argument;
                String name = select.identifier().name();
                return select.symbolType().is("java.time.temporal.ChronoField") && ("YEAR".equals(name) || "YEAR_OF_ERA".equals(name));
            }
            return false;
        }
    }
}

