/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Locale;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.location.Position;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

@Rule(key="S2681")
public class MultilineBlocksCurlyBracesCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String LOOP_MESSAGE = "This line will not be executed in a loop; only the first line of this %d-line block will be. The rest will execute only once.";
    private static final String LOOP_MESSAGE_ONE_LINER = "This statement will not be executed in a loop; only the first statement will be. The rest will execute only once.";
    private static final String IF_MESSAGE = "This line will not be executed conditionally; only the first line of this %d-line block will be. The rest will execute unconditionally.";
    private static final String IF_MESSAGE_ONE_LINER = "This statement will not be executed conditionally; only the first statement will be. The rest will execute unconditionally.";
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitBlock(BlockTree tree) {
        super.visitBlock(tree);
        StatementTree previous = null;
        for (StatementTree current : tree.body()) {
            if (previous != null) {
                this.check(current, previous);
            }
            previous = current;
        }
    }

    private void check(StatementTree current, StatementTree previous) {
        StatementTree block = null;
        boolean condition = false;
        if (previous.is(new Tree.Kind[]{Tree.Kind.FOR_EACH_STATEMENT})) {
            block = ((ForEachStatement)previous).statement();
        } else if (previous.is(new Tree.Kind[]{Tree.Kind.FOR_STATEMENT})) {
            block = ((ForStatementTree)previous).statement();
        } else if (previous.is(new Tree.Kind[]{Tree.Kind.WHILE_STATEMENT})) {
            block = ((WhileStatementTree)previous).statement();
        } else if (previous.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            block = MultilineBlocksCurlyBracesCheck.getIfStatementLastBlock(previous);
            condition = true;
        }
        if (block != null && !block.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            Position previousTokenStart = Position.startOf((Tree)block);
            int previousColumn = previousTokenStart.column();
            int previousLine = previousTokenStart.line();
            Position currentTokenStart = Position.startOf((Tree)current);
            int currentColumn = currentTokenStart.column();
            int currentLine = currentTokenStart.line();
            if (previousColumn == currentColumn && previousLine + 1 == currentLine || previousLine == Position.startOf((Tree)previous).line() && Position.startOf((Tree)previous).column() < currentColumn) {
                int lines = 1 + currentLine - previousLine;
                this.context.reportIssue((JavaCheck)this, (Tree)current, MultilineBlocksCurlyBracesCheck.getMessage(condition, lines));
            }
        }
    }

    private static String getMessage(boolean ifStatementMessage, int lines) {
        if (lines == 1) {
            return ifStatementMessage ? IF_MESSAGE_ONE_LINER : LOOP_MESSAGE_ONE_LINER;
        }
        return String.format(Locale.US, ifStatementMessage ? IF_MESSAGE : LOOP_MESSAGE, lines);
    }

    private static StatementTree getIfStatementLastBlock(StatementTree statementTree) {
        StatementTree block = statementTree;
        while (block.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            IfStatementTree ifStatementTree = (IfStatementTree)block;
            StatementTree elseStatement = ifStatementTree.elseStatement();
            block = elseStatement == null ? ifStatementTree.thenStatement() : elseStatement;
        }
        return block;
    }
}

