/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1996")
public class OneClassInterfacePerFileCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.COMPILATION_UNIT);
    }

    public void visitNode(Tree tree) {
        int types = ((CompilationUnitTree)tree).types().size();
        if (types > 1) {
            this.context.addIssue(-1, (JavaCheck)this, "There are " + types + " top-level types in this file; move all but one of them to other files.", Integer.valueOf(types - 1));
        }
    }
}

