/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2333")
public class RedundantModifierCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE, Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.RECORD);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (classTree.is(new Tree.Kind[]{Tree.Kind.RECORD})) {
            this.checkRedundantModifiers(classTree.modifiers(), Modifier.FINAL);
        }
        for (Tree member : classTree.members()) {
            switch (member.kind()) {
                case METHOD: {
                    this.checkMethod((MethodTree)member, classTree);
                    break;
                }
                case VARIABLE: {
                    this.checkVariable((VariableTree)member, classTree);
                    break;
                }
                case CONSTRUCTOR: {
                    if (!tree.is(new Tree.Kind[]{Tree.Kind.ENUM})) break;
                    this.checkRedundantModifiers(((MethodTree)member).modifiers(), Modifier.PRIVATE);
                    break;
                }
                case INTERFACE: {
                    ClassTree nestedClass = (ClassTree)member;
                    this.checkNestedInterface(nestedClass, classTree);
                    this.checkNestedType(nestedClass, classTree);
                    break;
                }
                case CLASS: {
                    this.checkNestedType((ClassTree)member, classTree);
                    break;
                }
            }
        }
    }

    private void checkMethod(MethodTree methodTree, ClassTree classTree) {
        ModifiersTree modifiers = methodTree.modifiers();
        if (RedundantModifierCheck.isInterfaceOrAnnotation((Tree)classTree)) {
            this.checkRedundantModifiers(modifiers, Modifier.ABSTRACT, Modifier.PUBLIC);
        } else if (classTree.is(new Tree.Kind[]{Tree.Kind.RECORD}) || ModifiersUtils.hasModifier((ModifiersTree)classTree.modifiers(), (Modifier)Modifier.FINAL)) {
            this.checkRedundantModifiers(modifiers, Modifier.FINAL);
        }
    }

    private void checkVariable(VariableTree variableTree, ClassTree classTree) {
        if (RedundantModifierCheck.isInterfaceOrAnnotation((Tree)classTree)) {
            ModifiersTree modifiers = variableTree.modifiers();
            this.checkRedundantModifiers(modifiers, Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL);
        }
    }

    private void checkNestedType(ClassTree nested, ClassTree classTree) {
        if (RedundantModifierCheck.isInterfaceOrAnnotation((Tree)classTree)) {
            ModifiersTree modifiers = nested.modifiers();
            this.checkRedundantModifiers(modifiers, Modifier.PUBLIC, Modifier.STATIC);
        }
    }

    private void checkNestedInterface(ClassTree nested, ClassTree classTree) {
        if (classTree.is(new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.ENUM})) {
            this.checkRedundantModifiers(nested.modifiers(), Modifier.STATIC);
        }
    }

    private static boolean isInterfaceOrAnnotation(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE});
    }

    private void checkRedundantModifiers(ModifiersTree modifiersTree, Modifier ... modifiers) {
        for (Modifier modifier : modifiers) {
            ModifierKeywordTree foundModifier = ModifiersUtils.getModifier((ModifiersTree)modifiersTree, (Modifier)modifier);
            if (foundModifier == null) continue;
            this.reportIssue((Tree)foundModifier, String.format("\"%s\" is redundant in this context.", foundModifier.keyword().text()));
        }
    }
}

