/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ReassignmentFinder;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2077")
public class SQLInjectionCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_SQL_STATEMENT = "java.sql.Statement";
    private static final String JAVA_SQL_CONNECTION = "java.sql.Connection";
    private static final String SPRING_JDBC_OPERATIONS = "org.springframework.jdbc.core.JdbcOperations";
    private static final MethodMatchers SQL_INJECTION_SUSPECTS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"org.hibernate.Session"}).names(new String[]{"createQuery", "createSQLQuery"}).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"java.sql.Statement"}).names(new String[]{"executeQuery", "execute", "executeUpdate", "executeLargeUpdate", "addBatch"}).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"java.sql.Connection"}).names(new String[]{"prepareStatement", "prepareCall", "nativeSQL"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"javax.persistence.EntityManager"}).names(new String[]{"createNativeQuery", "createQuery"}).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"org.springframework.jdbc.core.JdbcOperations"}).names(new String[]{"batchUpdate", "execute", "query", "queryForList", "queryForMap", "queryForObject", "queryForRowSet", "queryForInt", "queryForLong", "update"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"org.springframework.jdbc.core.PreparedStatementCreatorFactory"}).names(new String[]{"<init>", "newPreparedStatementCreator"}).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"javax.jdo.PersistenceManager"}).names(new String[]{"newQuery"}).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"javax.jdo.Query"}).names(new String[]{"setFilter", "setGrouping"}).withAnyParameters().build()});
    private static final String MAIN_MESSAGE = "Make sure using a dynamically formatted SQL query is safe here.";

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        Optional<ExpressionTree> sqlStringArg;
        if (SQLInjectionCheck.anyMatch(tree) && (sqlStringArg = SQLInjectionCheck.arguments(tree).filter(arg -> arg.symbolType().is("java.lang.String")).findFirst()).isPresent()) {
            ExpressionTree sqlArg = sqlStringArg.get();
            if (SQLInjectionCheck.isDynamicConcatenation(sqlArg)) {
                this.reportIssue((Tree)sqlArg, MAIN_MESSAGE);
            } else if (sqlArg.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                IdentifierTree identifierTree = (IdentifierTree)sqlArg;
                Symbol symbol = identifierTree.symbol();
                ExpressionTree initializerOrExpression = ReassignmentFinder.getInitializerOrExpression((Tree)symbol.declaration());
                List reassignments = ReassignmentFinder.getReassignments((Tree)symbol.owner().declaration(), (List)symbol.usages());
                if (initializerOrExpression != null && SQLInjectionCheck.isDynamicConcatenation(initializerOrExpression) || reassignments.stream().anyMatch(SQLInjectionCheck::isDynamicPlusAssignment)) {
                    this.reportIssue((Tree)sqlArg, MAIN_MESSAGE, SQLInjectionCheck.secondaryLocations(initializerOrExpression, reassignments, identifierTree.name()), null);
                }
            }
        }
    }

    private static List<JavaFileScannerContext.Location> secondaryLocations(@Nullable ExpressionTree initializerOrExpression, List<AssignmentExpressionTree> reassignments, String identifierName) {
        List<JavaFileScannerContext.Location> secondaryLocations = reassignments.stream().map(assignment -> new JavaFileScannerContext.Location(String.format("SQL Query is assigned to '%s'", SQLInjectionCheck.getVariableName(assignment)), (Tree)assignment.expression())).collect(Collectors.toList());
        if (initializerOrExpression != null) {
            secondaryLocations.add(new JavaFileScannerContext.Location(String.format("SQL Query is dynamically formatted and assigned to '%s'", identifierName), (Tree)initializerOrExpression));
        }
        return secondaryLocations;
    }

    private static String getVariableName(AssignmentExpressionTree assignment) {
        ExpressionTree variable = assignment.variable();
        return ((IdentifierTree)variable).name();
    }

    private static Stream<ExpressionTree> arguments(Tree methodTree) {
        if (methodTree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return ((MethodInvocationTree)methodTree).arguments().stream();
        }
        if (methodTree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            return ((NewClassTree)methodTree).arguments().stream();
        }
        return Stream.empty();
    }

    private static boolean anyMatch(Tree tree) {
        if (!SQLInjectionCheck.hasArguments(tree)) {
            return false;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            return SQL_INJECTION_SUSPECTS.matches((NewClassTree)tree);
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return SQL_INJECTION_SUSPECTS.matches((MethodInvocationTree)tree);
        }
        return false;
    }

    private static boolean hasArguments(Tree tree) {
        return SQLInjectionCheck.arguments(tree).findAny().isPresent();
    }

    private static boolean isDynamicPlusAssignment(ExpressionTree arg) {
        return arg.is(new Tree.Kind[]{Tree.Kind.PLUS_ASSIGNMENT}) && !((AssignmentExpressionTree)arg).expression().asConstant().isPresent();
    }

    private static boolean isDynamicConcatenation(ExpressionTree arg) {
        return arg.is(new Tree.Kind[]{Tree.Kind.PLUS}) && !arg.asConstant().isPresent();
    }
}

