/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BreakStatementTree;
import org.sonar.plugins.java.api.tree.ContinueStatementTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

@Rule(key="S135")
public class SeveralBreakOrContinuePerLoopCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private final Deque<List<Tree>> breakAndContinueCounter = new ArrayDeque<List<Tree>>();
    private final Deque<Boolean> currentScopeIsSwitch = new ArrayDeque<Boolean>();
    private int loopCount;
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.loopCount = 0;
        this.scan((Tree)context.getTree());
    }

    public void visitForStatement(ForStatementTree tree) {
        this.enterLoop();
        super.visitForStatement(tree);
        this.leaveLoop((Tree)tree.forKeyword());
    }

    public void visitForEachStatement(ForEachStatement tree) {
        this.enterLoop();
        super.visitForEachStatement(tree);
        this.leaveLoop((Tree)tree.forKeyword());
    }

    public void visitWhileStatement(WhileStatementTree tree) {
        this.enterLoop();
        super.visitWhileStatement(tree);
        this.leaveLoop((Tree)tree.whileKeyword());
    }

    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.enterLoop();
        super.visitDoWhileStatement(tree);
        this.leaveLoop((Tree)tree.doKeyword());
    }

    public void visitBreakStatement(BreakStatementTree tree) {
        if (this.isInLoop() && !this.isInSwitch()) {
            this.incrementBreakCounter((Tree)tree);
        }
        super.visitBreakStatement(tree);
    }

    public void visitContinueStatement(ContinueStatementTree tree) {
        if (this.isInLoop()) {
            this.incrementBreakCounter((Tree)tree);
        }
        super.visitContinueStatement(tree);
    }

    private boolean isInLoop() {
        return this.loopCount > 0;
    }

    private boolean isInSwitch() {
        return this.currentScopeIsSwitch.peek();
    }

    private void incrementBreakCounter(Tree tree) {
        if (!this.breakAndContinueCounter.isEmpty()) {
            this.breakAndContinueCounter.peek().add(tree);
        }
    }

    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.currentScopeIsSwitch.push(true);
        super.visitSwitchStatement(tree);
        this.currentScopeIsSwitch.pop();
    }

    private void enterLoop() {
        ++this.loopCount;
        this.breakAndContinueCounter.push(new ArrayList());
        this.currentScopeIsSwitch.push(false);
    }

    private void leaveLoop(Tree primaryLocationTree) {
        List<Object> breakAndContinues = new ArrayList();
        if (!this.breakAndContinueCounter.isEmpty()) {
            breakAndContinues = this.breakAndContinueCounter.pop();
        }
        if (breakAndContinues.size() > 1) {
            int effortToFix = breakAndContinues.size() - 1;
            List secondaryLocations = breakAndContinues.stream().map(t -> new JavaFileScannerContext.Location(String.format("\"%s\" statement.", t.is(new Tree.Kind[]{Tree.Kind.BREAK_STATEMENT}) ? "break" : "continue"), t)).collect(Collectors.toList());
            this.context.reportIssue((JavaCheck)this, primaryLocationTree, "Reduce the total number of break and continue statements in this loop to use at most one.", secondaryLocations, Integer.valueOf(effortToFix));
        }
        --this.loopCount;
        this.currentScopeIsSwitch.pop();
    }
}

