/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3030")
public class StaticImportCountCheck
extends IssuableSubscriptionVisitor {
    private static final int DEFAULT_THRESHOLD = 4;
    @RuleProperty(key="threshold", description="The maximum number of static imports allowed", defaultValue="4")
    private int threshold = 4;

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.COMPILATION_UNIT);
    }

    public void visitNode(Tree tree) {
        CompilationUnitTree cut = (CompilationUnitTree)tree;
        List staticImports = cut.imports().stream().filter(importClauseTree -> importClauseTree.is(new Tree.Kind[]{Tree.Kind.IMPORT}) && ((ImportTree)importClauseTree).isStatic()).collect(Collectors.toList());
        int staticImportsCount = staticImports.size();
        if (staticImportsCount > this.threshold) {
            List flow = staticImports.stream().map(importStatement -> new JavaFileScannerContext.Location("+1", (Tree)importStatement)).collect(Collectors.toList());
            String message = String.format("Reduce the number of \"static\" imports in this class from %d to the maximum allowed %d.", staticImportsCount, this.threshold);
            this.reportIssue((Tree)staticImports.get(0), message, flow, null);
        }
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }
}

