/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5664")
public class TextBlockTabsAndSpacesCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.TEXT_BLOCK);
    }

    private static char indentationCharacter(String[] lines) {
        for (String line : lines) {
            if (line.isEmpty() || line.charAt(0) == '\"') continue;
            return line.charAt(0);
        }
        return '\u0000';
    }

    private static boolean containsWrongIndentation(String line, int indent, char indentationCharacter) {
        for (int i = 0; i < line.length() && i < indent; ++i) {
            if (line.charAt(i) == indentationCharacter) continue;
            return true;
        }
        return false;
    }

    private static boolean containsWrongIndentation(LiteralTree textBlock) {
        String[] lines = textBlock.value().split("\r?\n|\r");
        int indent = LiteralUtils.indentationOfTextBlock((String[])lines);
        char indentationCharacter = TextBlockTabsAndSpacesCheck.indentationCharacter(lines);
        return indent > 0 && Arrays.stream(lines).skip(1L).anyMatch(line -> TextBlockTabsAndSpacesCheck.containsWrongIndentation(line, indent, indentationCharacter));
    }

    public void visitNode(Tree tree) {
        LiteralTree textBlock = (LiteralTree)tree;
        if (TextBlockTabsAndSpacesCheck.containsWrongIndentation(textBlock)) {
            this.reportIssue(tree, "Use only spaces or only tabs for indentation");
        }
    }
}

