/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import java.util.List;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class ClassPatternsUtils {
    private ClassPatternsUtils() {
    }

    public static boolean isPrivateInnerClass(ClassTree classTree) {
        return !classTree.symbol().owner().isPackageSymbol() && ModifiersUtils.hasModifier((ModifiersTree)classTree.modifiers(), (Modifier)Modifier.PRIVATE);
    }

    public static boolean isUtilityClass(ClassTree classTree) {
        return !ClassPatternsUtils.anonymousClass(classTree) && ClassPatternsUtils.hasOnlyStaticMembers(classTree) && !ClassPatternsUtils.extendsAnotherClassOrImplementsSerializable(classTree) && !ClassPatternsUtils.containsMainMethod(classTree);
    }

    private static boolean containsMainMethod(ClassTree classTree) {
        return classTree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.METHOD})).anyMatch(method -> MethodTreeUtils.isMainMethod((MethodTree)method));
    }

    private static boolean hasOnlyStaticMembers(ClassTree classTree) {
        List members = classTree.members();
        if (ClassPatternsUtils.noStaticMember(members)) {
            return false;
        }
        return members.stream().allMatch(member -> ClassPatternsUtils.isConstructor(member) || ClassPatternsUtils.isStatic(member) || member.is(new Tree.Kind[]{Tree.Kind.EMPTY_STATEMENT}));
    }

    private static boolean anonymousClass(ClassTree classTree) {
        return classTree.simpleName() == null;
    }

    private static boolean extendsAnotherClassOrImplementsSerializable(ClassTree classTree) {
        return classTree.superClass() != null || classTree.symbol().type().isSubtypeOf("java.io.Serializable");
    }

    private static boolean noStaticMember(List<Tree> members) {
        return members.stream().noneMatch(ClassPatternsUtils::isStatic);
    }

    private static boolean isStatic(Tree member) {
        if (member.is(new Tree.Kind[]{Tree.Kind.STATIC_INITIALIZER})) {
            return true;
        }
        if (member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            VariableTree variableTree = (VariableTree)member;
            return ClassPatternsUtils.hasStaticModifier(variableTree.modifiers());
        }
        if (member.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            MethodTree methodTree = (MethodTree)member;
            return ClassPatternsUtils.hasStaticModifier(methodTree.modifiers());
        }
        if (ClassPatternsUtils.isClassTree(member)) {
            ClassTree classTree = (ClassTree)member;
            return ClassPatternsUtils.hasStaticModifier(classTree.modifiers());
        }
        return false;
    }

    private static boolean isClassTree(Tree member) {
        return member.is(new Tree.Kind[]{Tree.Kind.CLASS}) || member.is(new Tree.Kind[]{Tree.Kind.ANNOTATION_TYPE}) || member.is(new Tree.Kind[]{Tree.Kind.INTERFACE}) || member.is(new Tree.Kind[]{Tree.Kind.ENUM});
    }

    private static boolean hasStaticModifier(ModifiersTree modifiers) {
        return ModifiersUtils.hasModifier((ModifiersTree)modifiers, (Modifier)Modifier.STATIC);
    }

    private static boolean isConstructor(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR});
    }
}

