/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6293")
public class AndroidBiometricAuthWithoutCryptoCheck
extends AbstractMethodDetection {
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"android.hardware.biometrics.BiometricPrompt"}).names(new String[]{"authenticate"}).addParametersMatcher(new String[]{"android.os.CancellationSignal", "java.util.concurrent.Executor", "android.hardware.biometrics.BiometricPrompt$AuthenticationCallback"}).build(), MethodMatchers.create().ofTypes(new String[]{"androidx.biometric.BiometricPrompt"}).names(new String[]{"authenticate"}).addParametersMatcher(new String[]{"androidx.biometric.BiometricPrompt$PromptInfo"}).build()});
    }

    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), "Make sure performing a biometric authentication without a \"CryptoObject\" is safe here.");
    }
}

