/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.Preconditions;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2053")
public class UnpredictableSaltCheck
extends IssuableSubscriptionVisitor {
    private static final String UNPREDICTABLE_SALT = "Make this salt unpredictable.";
    private static final String BYTE_ARRAY = "byte[]";
    private static final MethodMatchers NEW_PBE_KEY_SPEC = MethodMatchers.create().ofSubTypes(new String[]{"javax.crypto.spec.PBEKeySpec"}).constructor().addParametersMatcher(new String[]{"char[]", "byte[]", "int", "int"}).addParametersMatcher(new String[]{"char[]", "byte[]", "int"}).build();
    private static final MethodMatchers NEW_PBE_PARAM_SPEC = MethodMatchers.create().ofSubTypes(new String[]{"javax.crypto.spec.PBEParameterSpec"}).constructor().addParametersMatcher(new String[]{"byte[]", "int"}).addParametersMatcher(new String[]{"byte[]", "int", "java.security.spec.AlgorithmParameterSpec"}).build();
    private static final MethodMatchers GET_BYTES = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"getBytes"}).withAnyParameters().build();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        NewClassTree newClassTree = (NewClassTree)tree;
        UnpredictableSaltCheck.saltExpression((NewClassTree)tree).map(ExpressionUtils::skipParentheses).ifPresent(salt -> {
            ArrayList<JavaFileScannerContext.Location> locations = new ArrayList<JavaFileScannerContext.Location>();
            if (UnpredictableSaltCheck.isPredictable(salt, locations)) {
                this.reportIssue((Tree)newClassTree, UNPREDICTABLE_SALT, locations, null);
            }
        });
    }

    private static Optional<ExpressionTree> saltExpression(NewClassTree tree) {
        if (NEW_PBE_KEY_SPEC.matches(tree)) {
            return Optional.of((ExpressionTree)tree.arguments().get(1));
        }
        if (NEW_PBE_PARAM_SPEC.matches(tree)) {
            return Optional.of((ExpressionTree)tree.arguments().get(0));
        }
        return Optional.empty();
    }

    private static boolean isPredictable(ExpressionTree saltExpression, List<JavaFileScannerContext.Location> locations) {
        return saltExpression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && UnpredictableSaltCheck.isInitializedWithGetBytes((MethodInvocationTree)saltExpression) || saltExpression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && UnpredictableSaltCheck.isInitializedWithLiteral((IdentifierTree)saltExpression, locations);
    }

    private static boolean isInitializedWithLiteral(IdentifierTree identifier, List<JavaFileScannerContext.Location> locations) {
        Symbol symbol = identifier.symbol();
        return Optional.ofNullable(ExpressionsHelper.getSingleWriteUsage((Symbol)symbol)).filter(expressionTree -> expressionTree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})).map(MethodInvocationTree.class::cast).map(mit -> {
            locations.add(new JavaFileScannerContext.Location("Salt initialized with a constant.", (Tree)mit));
            return UnpredictableSaltCheck.isInitializedWithGetBytes(mit);
        }).orElse(false);
    }

    private static boolean isInitializedWithGetBytes(MethodInvocationTree mit) {
        if (!GET_BYTES.matches(mit)) {
            return false;
        }
        ExpressionTree methodSelect = mit.methodSelect();
        Preconditions.checkState((boolean)methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}), (String)"'getBytes' method invocation should have a MEMBER_SELECT kind as expression.");
        ExpressionTree expression = ((MemberSelectExpressionTree)methodSelect).expression();
        return expression.asConstant().isPresent();
    }
}

