/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public abstract class AbstractHardCodedCredentialChecker
extends IssuableSubscriptionVisitor {
    private static final Set<String> ALLOW_LIST = Collections.singleton("anonymous");
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    protected static final MethodMatchers STRING_TO_CHAR_ARRAY = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"toCharArray"}).addWithoutParametersMatcher().build();
    protected static final MethodMatchers EQUALS_MATCHER = MethodMatchers.create().ofAnyType().names(new String[]{"equals"}).addParametersMatcher(new String[]{"java.lang.Object"}).build();
    private List<Pattern> variablePatterns = null;
    private List<Pattern> literalPatterns = null;
    private static final int MINIMUM_CREDENTIAL_LENGTH = 2;

    protected abstract String getCredentialWords();

    protected abstract boolean isCredentialContainingPattern(ExpressionTree var1);

    protected abstract void report(Tree var1, String var2);

    private Stream<Pattern> variablePatterns() {
        if (this.variablePatterns == null) {
            this.variablePatterns = this.toPatterns("");
        }
        return this.variablePatterns.stream();
    }

    private Stream<Pattern> literalPatterns() {
        if (this.literalPatterns == null) {
            this.literalPatterns = this.toPatterns("=\\s*+([^\\\\ &;#,|]+)");
        }
        return this.literalPatterns.stream();
    }

    private List<Pattern> toPatterns(String suffix) {
        return Stream.of(this.getCredentialWords().split(",")).map(String::trim).map(word -> Pattern.compile("(" + word + ")" + suffix, 2)).toList();
    }

    protected Optional<String> isSettingCredential(MethodInvocationTree tree) {
        Arguments arguments = tree.arguments();
        if (arguments.size() == 2 && AbstractHardCodedCredentialChecker.isArgumentsSuperTypeOfString((List<ExpressionTree>)arguments) && !this.isCredentialContainingPattern((ExpressionTree)arguments.get(1)) && this.isPotentialCredential((ExpressionTree)arguments.get(1))) {
            return this.isCredential((ExpressionTree)arguments.get(0));
        }
        return Optional.empty();
    }

    private Optional<String> isCredential(ExpressionTree argument) {
        String value = (String)ExpressionsHelper.getConstantValueAsString((ExpressionTree)argument).value();
        if (StringUtils.isEmpty((CharSequence)value)) {
            return Optional.empty();
        }
        return this.variablePatterns().map(pattern -> pattern.matcher(value)).filter(Matcher::matches).map(matcher -> matcher.group(1)).findAny();
    }

    private Optional<String> isCredentialVariableName(IdentifierTree identifierTree) {
        return this.isCredentialLikeName(identifierTree.name());
    }

    protected Optional<String> isCredentialLikeName(String name) {
        return this.variablePatterns().map(pattern -> pattern.matcher(name)).filter(Matcher::find).map(matcher -> matcher.group(1)).findAny();
    }

    protected Optional<String> isCredentialVariable(ExpressionTree variable) {
        if (variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return this.isCredentialVariableName(((MemberSelectExpressionTree)variable).identifier());
        }
        if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return this.isCredentialVariableName((IdentifierTree)variable);
        }
        return Optional.empty();
    }

    protected boolean isCallOnStringLiteral(ExpressionTree expr) {
        return expr.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && this.isPotentialCredential(((MemberSelectExpressionTree)expr).expression());
    }

    protected void handleStringLiteral(LiteralTree tree) {
        String cleanedLiteral = LiteralUtils.trimQuotes((String)tree.value());
        if (!this.isPartOfConstantCredentialDeclaration(tree)) {
            this.literalPatterns().map(pattern -> pattern.matcher(cleanedLiteral)).filter(Matcher::find).filter(matcher -> !this.isExcludedLiteral(matcher.group(2))).findAny().ifPresent(matcher -> this.report((Tree)tree, matcher.group(1)));
        }
    }

    private boolean isPartOfConstantCredentialDeclaration(LiteralTree tree) {
        Tree parent = tree.parent();
        return parent != null && parent.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && this.isCredentialVariableName(((VariableTree)parent).simpleName()).isPresent();
    }

    protected boolean isPotentialCredential(String literal) {
        String trimmed = literal.trim();
        return trimmed.length() >= 2 && !ALLOW_LIST.contains(trimmed);
    }

    private boolean isExcludedLiteral(String followingString) {
        return !this.isPotentialCredential(followingString) || followingString.startsWith("?") || followingString.startsWith(":") || followingString.contains("%s");
    }

    protected void handleVariable(VariableTree tree) {
        IdentifierTree variable = tree.simpleName();
        this.isCredentialVariableName(variable).filter(credentialVariableName -> {
            ExpressionTree initializer = tree.initializer();
            return initializer != null && this.isNotExcluded(initializer) && !this.isCredentialContainingPattern(initializer);
        }).ifPresent(credentialVariableName -> this.report((Tree)variable, (String)credentialVariableName));
    }

    protected void handleAssignment(AssignmentExpressionTree tree) {
        ExpressionTree variable = tree.variable();
        this.isCredentialVariable(variable).filter(credentialVariableName -> this.isNotExcluded(tree.expression())).ifPresent(credentialVariableName -> this.report((Tree)variable, (String)credentialVariableName));
    }

    private static boolean isArgumentsSuperTypeOfString(List<ExpressionTree> arguments) {
        return arguments.stream().allMatch(arg -> arg.symbolType().is(JAVA_LANG_STRING) || arg.symbolType().is(JAVA_LANG_OBJECT));
    }

    private boolean isNotExcluded(ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)expression;
            return STRING_TO_CHAR_ARRAY.matches(mit) && this.isCallOnStringLiteral(mit.methodSelect());
        }
        return this.isPotentialCredential(expression);
    }

    protected boolean isPotentialCredential(ExpressionTree expression) {
        String value = (String)ExpressionsHelper.getConstantValueAsString((ExpressionTree)expression).value();
        if (value == null) {
            return false;
        }
        return this.isPotentialCredential(value);
    }

    protected void handleEqualsMethod(MethodInvocationTree mit, MemberSelectExpressionTree methodSelect) {
        ExpressionTree leftExpression = methodSelect.expression();
        ExpressionTree rightExpression = (ExpressionTree)mit.arguments().get(0);
        this.isCredentialVariable(leftExpression).filter(passwordVariableName -> this.isPotentialCredential(rightExpression) && !this.isCredentialContainingPattern(rightExpression)).ifPresent(passwordVariableName -> this.report((Tree)leftExpression, (String)passwordVariableName));
        this.isCredentialVariable(rightExpression).filter(passwordVariableName -> this.isPotentialCredential(leftExpression) && !this.isCredentialContainingPattern(leftExpression)).ifPresent(passwordVariableName -> this.report((Tree)rightExpression, (String)passwordVariableName));
    }
}

