/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S3398")
public class CallOuterPrivateMethodCheck
extends IssuableSubscriptionVisitor {
    private MethodInvocationVisitor methodInvocationVisitor;

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.INTERFACE);
    }

    public void setContext(JavaFileScannerContext context) {
        this.methodInvocationVisitor = new MethodInvocationVisitor();
        super.setContext(context);
    }

    public void leaveFile(JavaFileScannerContext context) {
        this.methodInvocationVisitor.checkUsages();
        this.methodInvocationVisitor = null;
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        Symbol.TypeSymbol classSymbol = classTree.symbol();
        if (CallOuterPrivateMethodCheck.isInnerClass((Symbol)classSymbol)) {
            this.methodInvocationVisitor.setClassSymbol(classSymbol);
            classTree.accept((TreeVisitor)this.methodInvocationVisitor);
        }
    }

    private static boolean isInnerClass(Symbol symbol) {
        return symbol.owner().isTypeSymbol();
    }

    private class MethodInvocationVisitor
    extends BaseTreeVisitor {
        private final Map<Symbol.TypeSymbol, Map<Symbol.MethodSymbol, Integer>> usagesByInnerClass = new HashMap<Symbol.TypeSymbol, Map<Symbol.MethodSymbol, Integer>>();
        private final Map<String, Set<MethodInvocationTree>> unknownInvocations = new HashMap<String, Set<MethodInvocationTree>>();
        private Symbol.TypeSymbol classSymbol;
        private Map<Symbol.MethodSymbol, Integer> usages;

        private MethodInvocationVisitor() {
        }

        public void setClassSymbol(Symbol.TypeSymbol classSymbol) {
            this.classSymbol = classSymbol;
            this.usages = new HashMap<Symbol.MethodSymbol, Integer>();
            this.usagesByInnerClass.put(classSymbol, this.usages);
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            Symbol.MethodSymbol symbol = tree.methodSymbol();
            if (symbol.isUnknown()) {
                String name = ExpressionUtils.methodName((MethodInvocationTree)tree).name();
                this.unknownInvocations.computeIfAbsent(name, k -> new HashSet()).add(tree);
            } else if (this.isPrivateMethodOfOuterClass((Symbol)symbol) && this.isInvocationOnCurrentInstance(tree)) {
                if (symbol.isParametrizedMethod() && symbol.declaration() != null) {
                    symbol = symbol.declaration().symbol();
                }
                this.usages.compute(symbol, (k, v) -> v == null ? 1 : v + 1);
            }
            super.visitMethodInvocation(tree);
        }

        private boolean isInvocationOnCurrentInstance(MethodInvocationTree tree) {
            ExpressionTree expressionTree = tree.methodSelect();
            if (expressionTree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                ExpressionTree memberSelectExpression = ((MemberSelectExpressionTree)expressionTree).expression();
                if (memberSelectExpression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                    return ExpressionUtils.isThis((ExpressionTree)((MemberSelectExpressionTree)memberSelectExpression).identifier());
                }
            }
            return expressionTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER});
        }

        private boolean isPrivateMethodOfOuterClass(Symbol symbol) {
            return symbol.isPrivate() && symbol.owner().equals((Object)this.classSymbol.owner()) && !"<init>".equals(symbol.name());
        }

        void checkUsages() {
            this.usagesByInnerClass.forEach((symbol, innerClassUsages) -> innerClassUsages.forEach((methodUsed, count) -> {
                boolean matchArity = ((Set)this.unknownInvocations.getOrDefault(methodUsed.name(), new HashSet())).stream().anyMatch(mit -> this.hasSameArity((Symbol.MethodSymbol)methodUsed, (MethodInvocationTree)mit));
                if (!matchArity && methodUsed.usages().size() == count.intValue()) {
                    this.reportIssueOnMethod(methodUsed.declaration(), (Symbol.TypeSymbol)symbol);
                }
            }));
        }

        private boolean hasSameArity(Symbol.MethodSymbol methodUsed, MethodInvocationTree mit) {
            int invokedArity;
            int formalArity = methodUsed.parameterTypes().size();
            return formalArity == (invokedArity = mit.arguments().size()) || methodUsed.isVarArgsMethod() && invokedArity >= formalArity - 1;
        }

        private void reportIssueOnMethod(@Nullable MethodTree declaration, Symbol.TypeSymbol classSymbol) {
            if (declaration != null && !this.isIllegalMove(declaration, classSymbol)) {
                Object message = "Move this method into ";
                message = classSymbol.name().isEmpty() ? (String)message + "the anonymous class declared at line " + ((JavaTree)classSymbol.declaration()).getLine() + "." : (String)message + "\"" + classSymbol.name() + "\".";
                CallOuterPrivateMethodCheck.this.reportIssue((Tree)declaration.simpleName(), (String)message);
            }
        }

        private boolean isIllegalMove(MethodTree declaration, Symbol.TypeSymbol classSymbol) {
            return declaration.symbol().isStatic() && !classSymbol.isStatic();
        }
    }
}

