/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1066")
public class CollapsibleIfCandidateCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;
    private Deque<IfStatementTree> outerIf = new ArrayDeque<IfStatementTree>();

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
        this.outerIf.clear();
    }

    public void visitIfStatement(IfStatementTree tree) {
        if (!this.outerIf.isEmpty() && !CollapsibleIfCandidateCheck.hasElseClause(tree)) {
            IfStatementTree outerIfStatement = this.outerIf.peek();
            QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)tree.ifKeyword()).withMessage("Merge this if statement with the enclosing one.").withSecondaries(Collections.singletonList(new JavaFileScannerContext.Location("", (Tree)outerIfStatement.ifKeyword()))).withQuickFix(() -> CollapsibleIfCandidateCheck.computeQuickFix(tree, outerIfStatement)).report();
        }
        if (!CollapsibleIfCandidateCheck.hasElseClause(tree) && CollapsibleIfCandidateCheck.hasBodySingleIfStatement(tree.thenStatement())) {
            this.outerIf.push(tree);
            super.visitIfStatement(tree);
            if (!this.outerIf.isEmpty()) {
                this.outerIf.pop();
            }
        } else {
            this.outerIf.clear();
            super.visitIfStatement(tree);
        }
    }

    private static boolean hasElseClause(IfStatementTree tree) {
        return tree.elseStatement() != null;
    }

    private static boolean hasBodySingleIfStatement(StatementTree thenStatement) {
        if (thenStatement.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            BlockTree block = (BlockTree)thenStatement;
            return block.body().size() == 1 && ((StatementTree)block.body().get(0)).is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT});
        }
        return thenStatement.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT});
    }

    private static JavaQuickFix computeQuickFix(IfStatementTree innerIf, IfStatementTree outerIf) {
        JavaQuickFix.Builder quickFixBuilder = JavaQuickFix.newQuickFix((String)"Merge this if statement with the enclosing one");
        quickFixBuilder.addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceBetweenTree((Tree)outerIf.condition(), (boolean)false, (Tree)innerIf.condition(), (boolean)false, (String)" && ")});
        CollapsibleIfCandidateCheck.addParenthesisIfRequired(quickFixBuilder, outerIf.condition());
        CollapsibleIfCandidateCheck.addParenthesisIfRequired(quickFixBuilder, innerIf.condition());
        StatementTree statementTree = outerIf.thenStatement();
        if (statementTree instanceof BlockTree) {
            BlockTree outerBlock = (BlockTree)statementTree;
            quickFixBuilder.addTextEdit(new JavaTextEdit[]{JavaTextEdit.removeTree((Tree)outerBlock.closeBraceToken())});
        }
        return quickFixBuilder.build();
    }

    private static void addParenthesisIfRequired(JavaQuickFix.Builder quickFixBuilder, ExpressionTree expression) {
        if (CollapsibleIfCandidateCheck.isLowerOperatorPrecedenceThanLogicalAnd(expression)) {
            quickFixBuilder.addTextEdit(new JavaTextEdit[]{JavaTextEdit.insertBeforeTree((Tree)expression, (String)"(")});
            quickFixBuilder.addTextEdit(new JavaTextEdit[]{JavaTextEdit.insertAfterTree((Tree)expression, (String)")")});
        }
    }

    private static boolean isLowerOperatorPrecedenceThanLogicalAnd(ExpressionTree expression) {
        boolean bl;
        if (expression instanceof BinaryExpressionTree) {
            BinaryExpressionTree binExpression = (BinaryExpressionTree)expression;
            bl = "||".equals(binExpression.operatorToken().text());
        } else {
            bl = expression.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPRESSION, Tree.Kind.ASSIGNMENT});
        }
        return bl;
    }
}

