/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

public abstract class CompareWithEqualsVisitor
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    protected JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        if (context.getSemanticModel() != null) {
            this.scan((Tree)context.getTree());
        }
    }

    public final void visitMethod(MethodTree tree) {
        if (!CompareWithEqualsVisitor.isEquals(tree)) {
            super.visitMethod(tree);
        }
    }

    public final void visitBinaryExpression(BinaryExpressionTree tree) {
        super.visitBinaryExpression(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO})) {
            this.checkEqualityExpression(tree);
        }
    }

    protected abstract void checkEqualityExpression(BinaryExpressionTree var1);

    private static boolean isEquals(MethodTree tree) {
        return MethodTreeUtils.isEqualsMethod(tree);
    }

    protected static boolean isNullComparison(Type leftOpType, Type rightOpType) {
        return leftOpType.isNullType() || rightOpType.isNullType();
    }

    protected static boolean isStringType(Type leftOpType, Type rightOpType) {
        return leftOpType.is(JAVA_LANG_STRING) && rightOpType.is(JAVA_LANG_STRING);
    }

    protected static boolean isBoxedType(Type leftOpType, Type rightOpType) {
        return leftOpType.isPrimitiveWrapper() && rightOpType.isPrimitiveWrapper();
    }

    protected void reportIssue(SyntaxToken opToken) {
        this.context.reportIssue((JavaCheck)this, (Tree)opToken, "Use the \"equals\" method if value comparison was intended.");
    }
}

