/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1301")
public class SwitchAtLeastThreeCasesCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.SWITCH_STATEMENT);
    }

    public void visitNode(Tree tree) {
        SwitchStatementTree switchStatementTree = (SwitchStatementTree)tree;
        int count = 0;
        for (CaseGroupTree caseGroup : switchStatementTree.cases()) {
            if (SwitchAtLeastThreeCasesCheck.hasLabelWithAllowedPattern(caseGroup)) {
                return;
            }
            count += caseGroup.labels().size();
        }
        if (count < 3) {
            this.reportIssue((Tree)switchStatementTree.switchKeyword(), "Replace this \"switch\" statement by \"if\" statements to increase readability.");
        }
    }

    private static boolean hasLabelWithAllowedPattern(CaseGroupTree caseGroupTree) {
        return caseGroupTree.labels().stream().flatMap(label -> label.expressions().stream()).anyMatch(expression -> expression.is(new Tree.Kind[]{Tree.Kind.TYPE_PATTERN, Tree.Kind.RECORD_PATTERN, Tree.Kind.GUARDED_PATTERN}));
    }
}

